/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;

class FaultToleranceParameter {
    private static final Logger LOGGER = Logger.getLogger(FaultToleranceParameter.class.getName());

    private FaultToleranceParameter() {
    }

    static String getParameter(String className, String methodName, String annotationType, String parameter) {
        String param = String.format("%s/%s/%s/%s", className, methodName, annotationType, parameter);
        return FaultToleranceParameter.getProperty(param);
    }

    static String getParameter(String className, String annotationType, String parameter) {
        String param = String.format("%s/%s/%s", className, annotationType, parameter);
        return FaultToleranceParameter.getProperty(param);
    }

    static String getParameter(String annotationType, String parameter) {
        String param = String.format("%s/%s", annotationType, parameter);
        return FaultToleranceParameter.getProperty(param);
    }

    private static String getProperty(String name) {
        try {
            String value = (String)ConfigProvider.getConfig().getValue(name, String.class);
            LOGGER.fine(() -> "Found config property '" + name + "' value '" + value + "'");
            return value;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

