/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.BulkheadAntn;
import io.helidon.microprofile.faulttolerance.CircuitBreakerAntn;
import io.helidon.microprofile.faulttolerance.CommandBinding;
import io.helidon.microprofile.faulttolerance.CommandInterceptor;
import io.helidon.microprofile.faulttolerance.FallbackAntn;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.LiteralCommandBinding;
import io.helidon.microprofile.faulttolerance.MethodAntn;
import io.helidon.microprofile.faulttolerance.RetryAntn;
import io.helidon.microprofile.faulttolerance.TimeoutAntn;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceExtension
implements Extension {
    static final String MP_FT_NON_FALLBACK_ENABLED = "MP_Fault_Tolerance_NonFallback_Enabled";
    static final String MP_FT_METRICS_ENABLED = "MP_Fault_Tolerance_Metrics_Enabled";
    private static boolean isFaultToleranceEnabled = true;
    private static boolean isFaultToleranceMetricsEnabled = true;
    private Set<BeanMethod> registeredMethods;

    static boolean isFaultToleranceEnabled() {
        return isFaultToleranceEnabled;
    }

    static boolean isFaultToleranceMetricsEnabled() {
        return isFaultToleranceMetricsEnabled;
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery discovery, BeanManager bm) {
        Config config = ConfigProvider.getConfig();
        isFaultToleranceEnabled = config.getOptionalValue(MP_FT_NON_FALLBACK_ENABLED, Boolean.class).orElse(true);
        isFaultToleranceMetricsEnabled = config.getOptionalValue(MP_FT_METRICS_ENABLED, Boolean.class).orElse(true);
        discovery.addInterceptorBinding(new InterceptorBindingAnnotatedType(bm.createAnnotatedType(Retry.class)));
        discovery.addInterceptorBinding(new InterceptorBindingAnnotatedType(bm.createAnnotatedType(CircuitBreaker.class)));
        discovery.addInterceptorBinding(new InterceptorBindingAnnotatedType(bm.createAnnotatedType(Timeout.class)));
        discovery.addInterceptorBinding(new InterceptorBindingAnnotatedType(bm.createAnnotatedType(Asynchronous.class)));
        discovery.addInterceptorBinding(new InterceptorBindingAnnotatedType(bm.createAnnotatedType(Bulkhead.class)));
        discovery.addInterceptorBinding(new InterceptorBindingAnnotatedType(bm.createAnnotatedType(Fallback.class)));
        discovery.addAnnotatedType(bm.createAnnotatedType(CommandInterceptor.class), CommandInterceptor.class.getName());
    }

    void registerFaultToleranceMethods(@Observes ProcessManagedBean<?> event) {
        AnnotatedType type = event.getAnnotatedBeanClass();
        for (AnnotatedMethod method : type.getMethods()) {
            if (!FaultToleranceExtension.isFaultToleranceMethod(type.getJavaClass(), method.getJavaMember())) continue;
            this.getRegisteredMethods().add(new BeanMethod(type.getJavaClass(), method.getJavaMember()));
        }
    }

    void registerFaultToleranceMetrics(@Observes AfterDeploymentValidation validation) {
        if (FaultToleranceMetrics.enabled()) {
            this.getRegisteredMethods().stream().forEach(beanMethod -> {
                Method method = beanMethod.method();
                Class<?> beanClass = beanMethod.beanClass();
                FaultToleranceMetrics.registerMetrics(method);
                if (MethodAntn.isAnnotationPresent(beanClass, method, Retry.class)) {
                    FaultToleranceMetrics.registerRetryMetrics(method);
                    new RetryAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, CircuitBreaker.class)) {
                    FaultToleranceMetrics.registerCircuitBreakerMetrics(method);
                    new CircuitBreakerAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, Timeout.class)) {
                    FaultToleranceMetrics.registerTimeoutMetrics(method);
                    new TimeoutAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, Bulkhead.class)) {
                    FaultToleranceMetrics.registerBulkheadMetrics(method);
                    new BulkheadAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, Fallback.class)) {
                    FaultToleranceMetrics.registerFallbackMetrics(method);
                    new FallbackAntn(beanClass, method).validate();
                }
            });
        }
    }

    private Set<BeanMethod> getRegisteredMethods() {
        if (this.registeredMethods == null) {
            this.registeredMethods = new CopyOnWriteArraySet<BeanMethod>();
        }
        return this.registeredMethods;
    }

    static Class<?> getRealClass(Object object) {
        Class<?> result = object.getClass();
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }

    static boolean isFaultToleranceMethod(Class<?> beanClass, Method method) {
        return MethodAntn.isAnnotationPresent(beanClass, method, Retry.class) || MethodAntn.isAnnotationPresent(beanClass, method, CircuitBreaker.class) || MethodAntn.isAnnotationPresent(beanClass, method, Bulkhead.class) || MethodAntn.isAnnotationPresent(beanClass, method, Timeout.class) || MethodAntn.isAnnotationPresent(beanClass, method, Asynchronous.class) || MethodAntn.isAnnotationPresent(beanClass, method, Fallback.class);
    }

    public static class InterceptorBindingAnnotatedType<T extends Annotation>
    implements AnnotatedType<T> {
        private final AnnotatedType<T> delegate;
        private final Set<Annotation> annotations;

        public InterceptorBindingAnnotatedType(AnnotatedType<T> delegate) {
            this.delegate = delegate;
            this.annotations = new HashSet<Annotation>(delegate.getAnnotations());
            this.annotations.add(LiteralCommandBinding.getInstance());
        }

        public Class<T> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public Set<AnnotatedConstructor<T>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super T>> getMethods() {
            return this.delegate.getMethods();
        }

        public Set<AnnotatedField<? super T>> getFields() {
            return this.delegate.getFields();
        }

        public <R extends Annotation> R getAnnotation(Class<R> annotationType) {
            if (CommandBinding.class.equals(annotationType)) {
                return (R)LiteralCommandBinding.getInstance();
            }
            return (R)this.delegate.getAnnotation(annotationType);
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return CommandBinding.class.equals(annotationType) || this.delegate.isAnnotationPresent(annotationType);
        }
    }

    private static class BeanMethod {
        private final Class<?> beanClass;
        private final Method method;

        BeanMethod(Class<?> beanClass, Method method) {
            this.beanClass = beanClass;
            this.method = method;
        }

        Class<?> beanClass() {
            return this.beanClass;
        }

        Method method() {
            return this.method;
        }
    }
}

