/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.helidon.microprofile.faulttolerance.BulkheadHelper;
import io.helidon.microprofile.faulttolerance.CircuitBreakerHelper;
import io.helidon.microprofile.faulttolerance.ExceptionUtil;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import io.helidon.microprofile.faulttolerance.TimeUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import org.apache.commons.configuration.AbstractConfiguration;
import org.eclipse.microprofile.metrics.Histogram;

public class FaultToleranceCommand
extends HystrixCommand<Object> {
    private static final Logger LOGGER = Logger.getLogger(FaultToleranceCommand.class.getName());
    static final String HELIDON_MICROPROFILE_FAULTTOLERANCE = "io.helidon.microprofile.faulttolerance";
    private final String commandKey;
    private final MethodIntrospector introspector;
    private final InvocationContext context;
    private long executionTime = -1L;
    private CircuitBreakerHelper breakerHelper;
    private BulkheadHelper bulkheadHelper;
    private long queuedNanos = -1L;
    private static final int MAX_THREAD_POOL_SIZE = 10;
    private static final int MAX_THREAD_POOL_QUEUE_SIZE = -1;

    public FaultToleranceCommand(String commandKey, MethodIntrospector introspector, InvocationContext context) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)HELIDON_MICROPROFILE_FAULTTOLERANCE)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withFallbackEnabled(false).withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)).andThreadPoolKey(introspector.hasBulkhead() ? HystrixThreadPoolKey.Factory.asKey((String)commandKey) : null).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(introspector.hasBulkhead() ? introspector.getBulkhead().value() : 10).withMaximumSize(introspector.hasBulkhead() ? introspector.getBulkhead().value() : 10).withMaxQueueSize(introspector.hasBulkhead() && introspector.isAsynchronous() ? introspector.getBulkhead().waitingTaskQueue() : -1).withQueueSizeRejectionThreshold(introspector.hasBulkhead() && introspector.isAsynchronous() ? introspector.getBulkhead().waitingTaskQueue() : -1)));
        this.commandKey = commandKey;
        this.introspector = introspector;
        this.context = context;
        if (introspector.hasCircuitBreaker()) {
            this.breakerHelper = new CircuitBreakerHelper(this, introspector.getCircuitBreaker());
            if (FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
                FaultToleranceMetrics.registerGauge(introspector.getMethod(), "circuitbreaker.open.total", "Amount of time the circuit breaker has spent in open state", () -> this.breakerHelper.getInStateNanos(CircuitBreakerHelper.State.OPEN_MP));
                FaultToleranceMetrics.registerGauge(introspector.getMethod(), "circuitbreaker.halfOpen.total", "Amount of time the circuit breaker has spent in half-open state", () -> this.breakerHelper.getInStateNanos(CircuitBreakerHelper.State.HALF_OPEN_MP));
                FaultToleranceMetrics.registerGauge(introspector.getMethod(), "circuitbreaker.closed.total", "Amount of time the circuit breaker has spent in closed state", () -> this.breakerHelper.getInStateNanos(CircuitBreakerHelper.State.CLOSED_MP));
            }
        }
        if (introspector.hasBulkhead()) {
            this.bulkheadHelper = new BulkheadHelper(commandKey, introspector.getBulkhead());
            if (FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
                this.queuedNanos = System.nanoTime();
                FaultToleranceMetrics.registerGauge(introspector.getMethod(), "bulkhead.concurrentExecutions", "Number of currently running executions", () -> this.bulkheadHelper.runningInvocations());
                if (introspector.isAsynchronous()) {
                    FaultToleranceMetrics.registerGauge(introspector.getMethod(), "bulkhead.waitingQueue.population", "Number of executions currently waiting in the queue", () -> this.bulkheadHelper.waitingInvocations());
                }
            }
        }
    }

    long getExecutionTime() {
        if (this.executionTime == -1L) {
            throw new IllegalStateException("Command has not been executed yet");
        }
        return this.executionTime;
    }

    public Object run() throws Exception {
        if (this.introspector.hasBulkhead()) {
            this.bulkheadHelper.markAsRunning(this);
            if (FaultToleranceExtension.isFaultToleranceMetricsEnabled() && this.introspector.isAsynchronous() && this.queuedNanos != -1L) {
                Method method = this.introspector.getMethod();
                Histogram histogram = FaultToleranceMetrics.getHistogram(method, "bulkhead.waiting.duration");
                if (histogram == null) {
                    FaultToleranceMetrics.registerHistogram(String.format("ft.%s.%s.%s", method.getDeclaringClass().getName(), method.getName(), "bulkhead.waiting.duration"), "Histogram of the time executions spend waiting in the queue");
                    histogram = FaultToleranceMetrics.getHistogram(method, "bulkhead.waiting.duration");
                }
                histogram.update(System.nanoTime() - this.queuedNanos);
            }
        }
        try {
            Object object = this.context.proceed();
            return object;
        }
        finally {
            if (this.introspector.hasBulkhead()) {
                this.bulkheadHelper.markAsNotRunning(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() {
        boolean lockRemoved = false;
        try {
            boolean hasFailed;
            this.introspector.getHystrixProperties().entrySet().forEach(entry -> this.setProperty((String)entry.getKey(), entry.getValue()));
            if (this.introspector.hasCircuitBreaker()) {
                this.breakerHelper.lock();
                if (this.breakerHelper.getState() == CircuitBreakerHelper.State.OPEN_MP) {
                    long delayNanos = TimeUtil.convertToNanos(this.introspector.getCircuitBreaker().delay(), this.introspector.getCircuitBreaker().delayUnit());
                    if (this.breakerHelper.getCurrentStateNanos() > delayNanos) {
                        this.breakerHelper.setState(CircuitBreakerHelper.State.HALF_OPEN_MP);
                    }
                }
                this.logCircuitBreakerState("Enter");
            }
            boolean wasBreakerOpen = this.isCircuitBreakerOpen();
            if (this.introspector.hasBulkhead()) {
                this.bulkheadHelper.trackInvocation(this);
            }
            Object result = null;
            Throwable throwable = null;
            long startNanos = System.nanoTime();
            try {
                result = super.execute();
            }
            catch (Throwable t) {
                throwable = t;
            }
            this.executionTime = System.nanoTime() - startNanos;
            boolean bl = hasFailed = throwable != null;
            if (this.introspector.hasCircuitBreaker()) {
                double failureRatio;
                boolean isClosedNow;
                this.breakerHelper.pushResult(throwable == null);
                boolean breakerOpening = false;
                boolean bl2 = isClosedNow = !wasBreakerOpen;
                if (hasFailed) {
                    Throwable throwableFinal = throwable;
                    Class[] throwableClasses = this.introspector.getCircuitBreaker().failOn();
                    boolean failOn = Arrays.asList(throwableClasses).stream().anyMatch(c -> c.isAssignableFrom(throwableFinal.getClass()));
                    if (!failOn) {
                        this.updateMetricsAfter(throwable, wasBreakerOpen, isClosedNow, breakerOpening);
                        this.logCircuitBreakerState("Exit 1");
                        throw ExceptionUtil.toWrappedException(throwable);
                    }
                }
                if (this.breakerHelper.getState() == CircuitBreakerHelper.State.CLOSED_MP && (failureRatio = this.breakerHelper.getFailureRatio()) >= this.introspector.getCircuitBreaker().failureRatio()) {
                    this.breakerHelper.setState(CircuitBreakerHelper.State.OPEN_MP);
                    breakerOpening = true;
                }
                if (hasFailed) {
                    if (this.breakerHelper.getState() == CircuitBreakerHelper.State.HALF_OPEN_MP) {
                        this.breakerHelper.setState(CircuitBreakerHelper.State.OPEN_MP);
                    }
                    this.updateMetricsAfter(throwable, wasBreakerOpen, isClosedNow, breakerOpening);
                    this.logCircuitBreakerState("Exit 2");
                    throw ExceptionUtil.toWrappedException(throwable);
                }
                this.breakerHelper.incSuccessCount();
                if (this.breakerHelper.getState() == CircuitBreakerHelper.State.HALF_OPEN_MP && this.breakerHelper.getSuccessCount() == this.introspector.getCircuitBreaker().successThreshold()) {
                    this.breakerHelper.setState(CircuitBreakerHelper.State.CLOSED_MP);
                    this.breakerHelper.resetCommandData();
                    lockRemoved = true;
                    isClosedNow = true;
                }
                this.updateMetricsAfter(throwable, wasBreakerOpen, isClosedNow, breakerOpening);
            }
            if (this.introspector.hasBulkhead()) {
                this.bulkheadHelper.untrackInvocation(this);
            }
            this.logCircuitBreakerState("Exit 3");
            if (throwable != null) {
                throw ExceptionUtil.toWrappedException(throwable);
            }
            Object object = result;
            return object;
        }
        finally {
            if (this.introspector.hasCircuitBreaker() && !lockRemoved) {
                this.breakerHelper.unlock();
            }
        }
    }

    private void updateMetricsAfter(Throwable throwable, boolean wasBreakerOpen, boolean isClosedNow, boolean breakerWillOpen) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        assert (this.introspector.hasCircuitBreaker());
        Method method = this.introspector.getMethod();
        if (throwable == null) {
            FaultToleranceMetrics.getCounter(method, "circuitbreaker.callsSucceeded.total").inc();
        } else if (!wasBreakerOpen) {
            FaultToleranceMetrics.getCounter(method, "circuitbreaker.callsFailed.total").inc();
            if (breakerWillOpen) {
                FaultToleranceMetrics.getCounter(method, "circuitbreaker.opened.total").inc();
            }
        }
        if (wasBreakerOpen && !isClosedNow) {
            FaultToleranceMetrics.getCounter(method, "circuitbreaker.callsPrevented.total").inc();
        }
    }

    private void setProperty(String key, Object value) {
        AbstractConfiguration configManager = ConfigurationManager.getConfigInstance();
        configManager.setProperty(String.format("hystrix.command.%s.%s", this.commandKey, key), value);
    }

    private void logCircuitBreakerState(String preamble) {
        if (this.introspector.hasCircuitBreaker()) {
            String hystrixState = this.isCircuitBreakerOpen() ? "OPEN" : "CLOSED";
            LOGGER.info(preamble + ": breaker for " + this.getCommandKey() + " in state " + (Object)((Object)this.breakerHelper.getState()) + " (Hystrix: " + hystrixState + " Thread:" + Thread.currentThread().getName() + ")");
        }
    }
}

