/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.FaultToleranceCommand;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.faulttolerance.Bulkhead;

public class BulkheadHelper {
    private static final Map<String, InvocationData> COMMAND_STATS = new ConcurrentHashMap<String, InvocationData>();
    private final String commandKey;
    private final Bulkhead bulkhead;

    BulkheadHelper(String commandKey, Bulkhead bulkhead) {
        this.commandKey = commandKey;
        this.bulkhead = bulkhead;
    }

    private InvocationData invocationData() {
        return COMMAND_STATS.computeIfAbsent(this.commandKey, d -> new InvocationData(this.bulkhead.value(), this.bulkhead.waitingTaskQueue()));
    }

    void trackInvocation(FaultToleranceCommand invocation) {
        this.invocationData().trackInvocation(invocation);
    }

    void untrackInvocation(FaultToleranceCommand invocation) {
        this.invocationData().untrackInvocation(invocation);
        if (this.runningInvocations() == 0 && this.waitingInvocations() == 0) {
            COMMAND_STATS.remove(this.commandKey);
        }
    }

    void markAsRunning(FaultToleranceCommand invocation) {
        this.invocationData().markAsRunning(invocation);
    }

    void markAsNotRunning(FaultToleranceCommand invocation) {
        this.invocationData().markAsNotRunning(invocation);
    }

    int runningInvocations() {
        return this.invocationData().runningInvocations();
    }

    int waitingInvocations() {
        return this.invocationData().waitingInvocations();
    }

    boolean isWaitingQueueFull() {
        return this.invocationData().isWaitingQueueFull();
    }

    boolean isAtMaxRunningInvocations() {
        return this.invocationData().isAtMaxRunningInvocations();
    }

    static class InvocationData {
        private final int maxRunningInvocations;
        private final int waitingQueueSize;
        private Set<FaultToleranceCommand> runningInvocations = new HashSet<FaultToleranceCommand>();
        private Set<FaultToleranceCommand> allInvocations = new HashSet<FaultToleranceCommand>();

        InvocationData(int maxRunningCommands, int waitingQueueSize) {
            this.maxRunningInvocations = maxRunningCommands;
            this.waitingQueueSize = waitingQueueSize;
        }

        synchronized boolean isWaitingQueueFull() {
            return this.waitingInvocations() == this.waitingQueueSize;
        }

        synchronized boolean isAtMaxRunningInvocations() {
            return this.runningInvocations.size() == this.maxRunningInvocations;
        }

        synchronized void trackInvocation(FaultToleranceCommand invocation) {
            this.allInvocations.add(invocation);
        }

        synchronized void untrackInvocation(FaultToleranceCommand invocation) {
            this.allInvocations.remove((Object)invocation);
        }

        synchronized int runningInvocations() {
            return this.runningInvocations.size();
        }

        synchronized void markAsRunning(FaultToleranceCommand invocation) {
            this.runningInvocations.add(invocation);
        }

        synchronized void markAsNotRunning(FaultToleranceCommand invocation) {
            this.runningInvocations.remove((Object)invocation);
        }

        synchronized int waitingInvocations() {
            return this.allInvocations.size() - this.runningInvocations.size();
        }
    }
}

