/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TimedHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final Logger LOGGER = Logger.getLogger(TimedHashMap.class.getName());
    private static final int THREAD_POOL_SIZE = 3;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(3);
    private final long ttlInMillis;
    private final Map<K, Long> created = new ConcurrentHashMap<K, Long>();

    public TimedHashMap(long ttlInMillis) {
        this.ttlInMillis = ttlInMillis;
        SCHEDULER.scheduleAtFixedRate(this::expireOldEntries, ttlInMillis, ttlInMillis, TimeUnit.MILLISECONDS);
    }

    private void expireOldEntries() {
        this.created.keySet().stream().filter(k -> System.currentTimeMillis() - this.created.get(k) > this.ttlInMillis).collect(Collectors.toSet()).stream().forEach((? super T k) -> {
            LOGGER.fine("Removing expired key " + k);
            this.remove(k);
            this.created.remove(k);
        });
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public V put(K key, V value) {
        this.created.put(key, System.currentTimeMillis());
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.keySet().stream().forEach((? super T k) -> this.created.put(k, System.currentTimeMillis()));
        super.putAll(m);
    }

    @Override
    public V remove(Object key) {
        this.created.remove(key);
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.created.clear();
        super.clear();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!this.created.containsKey(key)) {
            this.created.put(key, System.currentTimeMillis());
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = super.remove(key, value);
        if (removed) {
            this.created.remove(key);
        }
        return removed;
    }
}

