/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.config.Config;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class CommandScheduler
implements Scheduler {
    private static CommandScheduler instance;
    private final ScheduledThreadPoolSupplier poolSupplier;

    private CommandScheduler(ScheduledThreadPoolSupplier poolSupplier) {
        this.poolSupplier = poolSupplier;
    }

    public static synchronized CommandScheduler create(Config config) {
        if (instance == null) {
            instance = new CommandScheduler(ScheduledThreadPoolSupplier.create((Config)config));
        }
        return instance;
    }

    public static synchronized CommandScheduler create() {
        if (instance == null) {
            instance = new CommandScheduler(ScheduledThreadPoolSupplier.create());
        }
        return instance;
    }

    ScheduledThreadPoolSupplier poolSupplier() {
        return this.poolSupplier;
    }

    public ScheduledFuture<?> schedule(Callable<?> callable, long delay, TimeUnit unit) {
        return this.poolSupplier.get().schedule(callable, delay, unit);
    }

    static CommandScheduler instance() {
        return instance;
    }
}

