/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import com.netflix.hystrix.exception.HystrixRuntimeException;
import io.helidon.microprofile.faulttolerance.CommandFallback;
import io.helidon.microprofile.faulttolerance.CommandScheduler;
import io.helidon.microprofile.faulttolerance.ExceptionUtil;
import io.helidon.microprofile.faulttolerance.FailsafeChainedFuture;
import io.helidon.microprofile.faulttolerance.FaultToleranceCommand;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import io.helidon.microprofile.faulttolerance.TimeUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import net.jodah.failsafe.AsyncFailsafe;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.util.concurrent.Scheduler;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;

public class CommandRetrier {
    private static final Logger LOGGER = Logger.getLogger(CommandRetrier.class.getName());
    private final InvocationContext context;
    private final RetryPolicy retryPolicy;
    private final boolean isAsynchronous;
    private final MethodIntrospector introspector;
    private final Method method;
    private int invocationCount = 0;
    private FaultToleranceCommand command;

    public CommandRetrier(InvocationContext context, MethodIntrospector introspector) {
        this.context = context;
        this.introspector = introspector;
        this.isAsynchronous = introspector.isAsynchronous();
        this.method = context.getMethod();
        Retry retry = introspector.getRetry();
        if (retry != null) {
            this.retryPolicy = new RetryPolicy().withMaxRetries(retry.maxRetries()).withMaxDuration(retry.maxDuration(), TimeUtil.chronoUnitToTimeUnit(retry.durationUnit())).retryOn(retry.retryOn());
            if (retry.abortOn().length > 0) {
                this.retryPolicy.abortOn(retry.abortOn());
            }
            if (retry.jitter() > 0L) {
                double factor;
                long delay = TimeUtil.convertToNanos(retry.delay(), retry.delayUnit());
                long jitter = TimeUtil.convertToNanos(retry.jitter(), retry.jitterDelayUnit());
                if (jitter > delay) {
                    long diff = jitter - delay;
                    delay += diff / 2L;
                    factor = 1.0;
                } else {
                    factor = (double)jitter / (double)delay;
                }
                this.retryPolicy.withDelay(delay, TimeUnit.NANOSECONDS);
                this.retryPolicy.withJitter(factor);
            } else if (retry.delay() > 0L) {
                this.retryPolicy.withDelay(retry.delay(), TimeUtil.chronoUnitToTimeUnit(retry.delayUnit()));
            }
        } else {
            this.retryPolicy = new RetryPolicy().withMaxRetries(0);
        }
    }

    public Object execute() throws Exception {
        LOGGER.fine("Executing command with isAsynchronous = " + this.isAsynchronous);
        CheckedFunction fallbackFunction = t -> {
            CommandFallback fallback = new CommandFallback(this.context, this.introspector, (Throwable)t);
            return fallback.execute();
        };
        try {
            if (this.isAsynchronous) {
                CommandScheduler scheduler = CommandScheduler.create();
                AsyncFailsafe failsafe = Failsafe.with((RetryPolicy)this.retryPolicy).with((Scheduler)scheduler);
                FailsafeFuture chainedFuture = this.introspector.hasFallback() ? ((AsyncFailsafe)failsafe.withFallback(fallbackFunction)).get(this::retryExecute) : failsafe.get(this::retryExecute);
                return new FailsafeChainedFuture(chainedFuture);
            }
            SyncFailsafe failsafe = Failsafe.with((RetryPolicy)this.retryPolicy);
            return this.introspector.hasFallback() ? ((SyncFailsafe)failsafe.withFallback(fallbackFunction)).get(this::retryExecute) : failsafe.get(this::retryExecute);
        }
        catch (FailsafeException e) {
            throw ExceptionUtil.toException(e.getCause());
        }
    }

    private Object retryExecute() throws Exception {
        Object result;
        String commandKey = this.createCommandKey();
        this.command = new FaultToleranceCommand(commandKey, this.introspector, this.context);
        try {
            LOGGER.info("About to execute command with key " + this.command.getCommandKey());
            ++this.invocationCount;
            this.updateMetricsBefore();
            result = this.command.execute();
            this.updateMetricsAfter(null);
        }
        catch (ExceptionUtil.WrappedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HystrixRuntimeException) {
                cause = cause.getCause();
            }
            this.updateMetricsAfter(cause);
            if (cause instanceof TimeoutException) {
                throw new org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException(cause);
            }
            if (cause instanceof RejectedExecutionException) {
                throw new BulkheadException(cause);
            }
            if (CommandRetrier.isHystrixBreakerException(cause)) {
                throw new CircuitBreakerOpenException(cause);
            }
            throw ExceptionUtil.toException(cause);
        }
        return result;
    }

    private void updateMetricsBefore() {
        if (FaultToleranceExtension.isFaultToleranceMetricsEnabled() && this.introspector.hasRetry() && this.invocationCount > 1) {
            FaultToleranceMetrics.getCounter(this.method, "retry.retries.total").inc();
        }
    }

    private void updateMetricsAfter(Throwable cause) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        if (this.introspector.hasRetry()) {
            boolean firstInvocation;
            Retry retry = this.introspector.getRetry();
            boolean bl = firstInvocation = this.invocationCount == 1;
            if (cause == null) {
                FaultToleranceMetrics.getCounter(this.method, "invocations.total").inc();
                FaultToleranceMetrics.getCounter(this.method, firstInvocation ? "retry.callsSucceededNotRetried.total" : "retry.callsSucceededRetried.total").inc();
            } else if (retry.maxRetries() == this.invocationCount - 1) {
                FaultToleranceMetrics.getCounter(this.method, "retry.callsFailed.total").inc();
                FaultToleranceMetrics.getCounter(this.method, "invocations.failed.total").inc();
                FaultToleranceMetrics.getCounter(this.method, "invocations.total").inc();
            }
        } else {
            FaultToleranceMetrics.getCounter(this.method, "invocations.total").inc();
            if (cause != null) {
                FaultToleranceMetrics.getCounter(this.method, "invocations.failed.total").inc();
            }
        }
        if (this.introspector.hasTimeout()) {
            FaultToleranceMetrics.getHistogram(this.method, "timeout.executionDuration").update(this.command.getExecutionTime());
            FaultToleranceMetrics.getCounter(this.method, cause instanceof TimeoutException ? "timeout.callsTimedOut.total" : "timeout.callsNotTimedOut.total").inc();
        }
        if (this.introspector.hasBulkhead()) {
            boolean bulkheadRejection = cause instanceof RejectedExecutionException;
            if (!bulkheadRejection) {
                FaultToleranceMetrics.getHistogram(this.method, "bulkhead.executionDuration").update(this.command.getExecutionTime());
            }
            FaultToleranceMetrics.getCounter(this.method, bulkheadRejection ? "bulkhead.callsRejected.total" : "bulkhead.callsAccepted.total").inc();
        }
    }

    private String createCommandKey() {
        return this.method.getName() + Objects.hash(this.context.getTarget(), this.context.getMethod().hashCode());
    }

    private static boolean isHystrixBreakerException(Throwable t) {
        return t instanceof RuntimeException && t.getMessage().contains("Hystrix circuit short-circuited and is OPEN");
    }
}

