/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.CommandBinding;
import io.helidon.microprofile.faulttolerance.CommandRetrier;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@CommandBinding
@Priority(value=3000)
public class CommandInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CommandInterceptor.class.getName());

    @AroundInvoke
    public Object interceptCommand(InvocationContext context) throws Throwable {
        try {
            LOGGER.fine("Interceptor called for '" + context.getTarget().getClass() + "::" + context.getMethod().getName() + "'");
            MethodIntrospector introspector = new MethodIntrospector(context.getTarget().getClass(), context.getMethod());
            CommandRetrier retrier = new CommandRetrier(context, introspector);
            return retrier.execute();
        }
        catch (Throwable t) {
            LOGGER.fine("Throwable caught by interceptor '" + t.getMessage() + "'");
            throw t;
        }
    }
}

