/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.accesslog;

import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.webserver.accesslog.AccessLogFeature;
import io.helidon.webserver.spi.ServerFeature;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;

public class AccessLogCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(AccessLogCdiExtension.class.getName());

    private void setUpAccessLog(@Observes @Priority(value=10) @RuntimeStart Config config, BeanManager beanManager) {
        Config alConfig = config.get("server.access-log");
        Config newAlConfig = config.get("server.features.access-log");
        if (!alConfig.exists() && newAlConfig.exists()) {
            return;
        }
        if (alConfig.exists()) {
            LOGGER.log(System.Logger.Level.WARNING, "Configuration key server.access-log is deprecated, please use server.features.access-log instead");
        }
        ((ServerCdiExtension)beanManager.getExtension(ServerCdiExtension.class)).addFeature((ServerFeature)AccessLogFeature.create((Config)alConfig));
    }
}

