/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;

final class HelidonCounter
extends MetricImpl
implements Counter {
    private final Counter delegate;

    private HelidonCounter(String registryType, Metadata metadata, Counter delegate) {
        super(registryType, metadata);
        this.delegate = delegate;
    }

    static HelidonCounter create(String registryType, Metadata metadata) {
        return HelidonCounter.create(registryType, metadata, new CounterImpl());
    }

    static HelidonCounter create(String registryType, Metadata metadata, Counter metric) {
        return new HelidonCounter(registryType, metadata, metric);
    }

    public void inc() {
        this.delegate.inc();
    }

    public void inc(long n) {
        this.delegate.inc(n);
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        String metricName = this.prometheusName(metricID.getName());
        return metricName.endsWith("total") ? metricName : metricName + "_total";
    }

    @Override
    public String prometheusValue() {
        return Long.toString(this.getCount());
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        builder.add(HelidonCounter.jsonFullKey(metricID), this.getCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonCounter that = (HelidonCounter)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    private static class CounterImpl
    implements Counter {
        private final LongAdder adder = new LongAdder();

        private CounterImpl() {
        }

        public void inc() {
            this.adder.increment();
        }

        public void inc(long n) {
            this.adder.add(n);
        }

        public long getCount() {
            return this.adder.sum();
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getCount());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterImpl that = (CounterImpl)o;
            return this.getCount() == that.getCount();
        }
    }
}

