/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.metrics.InternalBridge;
import io.helidon.metrics.HelidonConcurrentGauge;
import io.helidon.metrics.HelidonCounter;
import io.helidon.metrics.HelidonGauge;
import io.helidon.metrics.HelidonHistogram;
import io.helidon.metrics.HelidonMetadata;
import io.helidon.metrics.HelidonMeter;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.HelidonTimer;
import io.helidon.metrics.InternalMetricIDImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class Registry
extends MetricRegistry
implements InternalBridge.MetricRegistry {
    private static final Tag[] NO_TAGS = new Tag[0];
    private static final Map<Class<? extends HelidonMetric>, MetricType> METRIC_TO_TYPE_MAP = Registry.prepareMetricToTypeMap();
    private final MetricRegistry.Type type;
    private final Map<MetricID, HelidonMetric> allMetrics = new ConcurrentHashMap<MetricID, HelidonMetric>();
    private final Map<String, List<MetricID>> allMetricIDsByName = new ConcurrentHashMap<String, List<MetricID>>();
    private final Map<String, Metadata> allMetadata = new ConcurrentHashMap<String, Metadata>();

    protected Registry(MetricRegistry.Type type) {
        this.type = type;
    }

    public static Registry create(MetricRegistry.Type type) {
        return new Registry(type);
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.registerUniqueMetric(name, metric);
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(metadata, metric, NO_TAGS);
    }

    public <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        return this.registerUniqueMetric(metadata, metric, tags);
    }

    public Counter counter(String name) {
        return this.counter(name, NO_TAGS);
    }

    public Counter counter(Metadata metadata) {
        return this.counter(metadata, NO_TAGS);
    }

    public Counter counter(InternalBridge.Metadata metadata) {
        return this.counter(Registry.toMetadata(metadata));
    }

    public Counter counter(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.counter(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Counter counter(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonCounter::create, HelidonCounter.class, tags);
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonCounter::create, HelidonCounter.class, tags);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, NO_TAGS);
    }

    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata, NO_TAGS);
    }

    public Histogram histogram(InternalBridge.Metadata metadata) {
        return this.histogram(Registry.toMetadata(metadata));
    }

    public Histogram histogram(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.histogram(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Histogram histogram(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonHistogram::create, HelidonHistogram.class, tags);
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonHistogram::create, HelidonHistogram.class, tags);
    }

    public Meter meter(String name) {
        return this.meter(name, NO_TAGS);
    }

    public Meter meter(Metadata metadata) {
        return this.meter(metadata, NO_TAGS);
    }

    public Meter meter(InternalBridge.Metadata metadata) {
        return this.meter(Registry.toMetadata(metadata));
    }

    public Meter meter(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.meter(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Meter meter(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonMeter::create, HelidonMeter.class, tags);
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonMeter::create, HelidonMeter.class, tags);
    }

    public Timer timer(String name) {
        return this.timer(name, NO_TAGS);
    }

    public Timer timer(Metadata metadata) {
        return this.timer(metadata, NO_TAGS);
    }

    public Timer timer(InternalBridge.Metadata metadata) {
        return this.timer(Registry.toMetadata(metadata));
    }

    public Timer timer(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.timer(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Timer timer(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonTimer::create, HelidonTimer.class, tags);
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonTimer::create, HelidonTimer.class, tags);
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return this.concurrentGauge(name, NO_TAGS);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return this.concurrentGauge(metadata, NO_TAGS);
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonConcurrentGauge::create, HelidonConcurrentGauge.class, tags);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonConcurrentGauge::create, HelidonConcurrentGauge.class, tags);
    }

    public synchronized boolean remove(String name) {
        boolean result = this.allMetricIDsByName.get(name).stream().map(metricID -> this.allMetrics.remove(metricID) != null).reduce((a, b) -> a != false || b != false).orElse(false);
        this.allMetricIDsByName.remove(name);
        this.allMetadata.remove(name);
        return result;
    }

    public synchronized boolean remove(MetricID metricID) {
        List<MetricID> likeNamedMetrics = this.allMetricIDsByName.get(metricID.getName());
        likeNamedMetrics.remove(metricID);
        if (likeNamedMetrics.isEmpty()) {
            this.allMetricIDsByName.remove(metricID.getName());
            this.allMetadata.remove(metricID.getName());
        }
        return this.allMetrics.remove(metricID) != null;
    }

    public synchronized void removeMatching(MetricFilter filter) {
        this.allMetrics.entrySet().stream().filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).map(entry -> this.remove((MetricID)entry.getKey())).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public SortedSet<String> getNames() {
        return this.allMetrics.keySet().stream().map(MetricID::getName).collect(Collectors.toCollection(TreeSet::new));
    }

    public SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.allMetrics.keySet());
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.getSortedMetrics(filter, Gauge.class);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Counter.class);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.getSortedMetrics(filter, Histogram.class);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Meter.class);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.getSortedMetrics(filter, Timer.class);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.getSortedMetrics(filter, ConcurrentGauge.class);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.allMetadata);
    }

    public Map<MetricID, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.allMetrics);
    }

    public synchronized Map<InternalBridge.MetricID, Metric> getBridgeMetrics(Predicate<? super Map.Entry<? extends InternalBridge.MetricID, ? extends Metric>> predicate) {
        HashMap<InternalBridge.MetricID, Metric> result = new HashMap<InternalBridge.MetricID, Metric>();
        this.allMetrics.entrySet().stream().map(Registry::toBridgeEntry).filter(predicate).forEach(entry -> result.put((InternalBridge.MetricID)entry.getKey(), (Metric)entry.getValue()));
        return result;
    }

    public Map<InternalBridge.MetricID, Metric> getBridgeMetrics() {
        return this.getBridgeMetrics(entry -> true);
    }

    public SortedMap<InternalBridge.MetricID, Gauge> getBridgeGauges() {
        return Registry.getBridgeMetrics(this.getGauges(), Gauge.class);
    }

    public SortedMap<InternalBridge.MetricID, Counter> getBridgeCounters() {
        return Registry.getBridgeMetrics(this.getCounters(), Counter.class);
    }

    public SortedMap<InternalBridge.MetricID, Histogram> getBridgeHistograms() {
        return Registry.getBridgeMetrics(this.getHistograms(), Histogram.class);
    }

    public SortedMap<InternalBridge.MetricID, Meter> getBridgeMeters() {
        return Registry.getBridgeMetrics(this.getMeters(), Meter.class);
    }

    public SortedMap<InternalBridge.MetricID, Timer> getBridgeTimers() {
        return Registry.getBridgeMetrics(this.getTimers(), Timer.class);
    }

    private static synchronized <T extends Metric> SortedMap<InternalBridge.MetricID, T> getBridgeMetrics(SortedMap<MetricID, T> metrics, Class<T> clazz) {
        return metrics.entrySet().stream().map(Registry::toBridgeEntry).filter(entry -> clazz.isAssignableFrom(((Metric)entry.getValue()).getClass())).collect(TreeMap::new, (map, entry) -> map.put((InternalBridge.MetricID)entry.getKey(), (Metric)clazz.cast(entry.getValue())), Map::putAll);
    }

    public <T extends Metric> T register(InternalBridge.Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(Registry.toMetadata(metadata), metric);
    }

    public <T extends Metric> T register(InternalBridge.MetricID metricID, T metric) throws IllegalArgumentException {
        return this.register((Metadata)Registry.toMetadata(metricID.getName(), metric), metric, Registry.toTags(metricID.getTags()));
    }

    private static Map.Entry<? extends InternalBridge.MetricID, ? extends Metric> toBridgeEntry(Map.Entry<? extends MetricID, ? extends Metric> entry) {
        return new AbstractMap.SimpleEntry<InternalMetricIDImpl, Metric>(new InternalMetricIDImpl(entry.getKey().getName(), entry.getKey().getTags()), entry.getValue());
    }

    public Optional<Metric> getMetric(String metricName) {
        return this.getOptionalMetricEntry(metricName).map(Map.Entry::getValue);
    }

    public Optional<Map.Entry<? extends InternalBridge.MetricID, ? extends Metric>> getBridgeMetric(String metricName) {
        return this.getOptionalMetricEntry(metricName).map(Registry::toBridgeEntry);
    }

    Stream<Map.Entry<MetricID, HelidonMetric>> stream() {
        return this.allMetrics.entrySet().stream();
    }

    public String type() {
        return this.type.getName();
    }

    public boolean empty() {
        return this.allMetrics.isEmpty();
    }

    public String toString() {
        return this.type() + ": " + this.allMetrics.size() + " metrics";
    }

    static Metadata toMetadata(InternalBridge.Metadata metadata) {
        MetadataBuilder builder = new MetadataBuilder();
        builder.withName(metadata.getName()).withDisplayName(metadata.getDisplayName()).reusable(metadata.isReusable());
        metadata.getDescription().ifPresent(arg_0 -> ((MetadataBuilder)builder).withDescription(arg_0));
        metadata.getUnit().ifPresent(arg_0 -> ((MetadataBuilder)builder).withUnit(arg_0));
        return builder.build();
    }

    synchronized Optional<Map.Entry<MetricID, HelidonMetric>> getOptionalMetricEntry(String metricName) {
        return this.getOptionalMetricWithIDsEntry(metricName).map(entry -> {
            MetricID metricID = (MetricID)((List)entry.getValue()).get(0);
            return new AbstractMap.SimpleImmutableEntry<MetricID, HelidonMetric>(metricID, this.allMetrics.get(metricID));
        });
    }

    <T extends HelidonMetric> Optional<T> getOptionalMetric(String metricName, Class<T> clazz, Tag ... tags) {
        return this.getOptionalMetric(new MetricID(metricName, tags), clazz);
    }

    <T extends HelidonMetric> Optional<T> getOptionalMetric(Metadata metadata, Class<T> clazz, Tag ... tags) {
        return this.getOptionalMetric(new MetricID(metadata.getName(), tags), clazz);
    }

    synchronized Optional<Map.Entry<HelidonMetric, List<MetricID>>> getOptionalMetricWithIDsEntry(String metricName) {
        List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
        if (metricIDs == null || metricIDs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AbstractMap.SimpleEntry<HelidonMetric, List<MetricID>>(this.allMetrics.get(metricIDs.get(0)), metricIDs));
    }

    <T extends HelidonMetric> Optional<T> getOptionalMetric(MetricID metricID, Class<T> clazz) {
        return Optional.ofNullable(this.allMetrics.get(metricID)).map(metric -> this.toType(metric, clazz));
    }

    MetricRegistry.Type registryType() {
        return this.type;
    }

    List<MetricID> metricIDsForName(String metricName) {
        return this.allMetricIDsByName.get(metricName);
    }

    static <T extends Metadata, U extends Metadata> boolean metadataMatches(T a, U b) {
        if (a == null && b == null || a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getName().equals(b.getName()) && a.getTypeRaw().equals((Object)b.getTypeRaw()) && a.getDisplayName().equals(b.getDisplayName()) && Objects.equals(a.getDescription(), b.getDescription()) && Objects.equals(a.getUnit(), b.getUnit()) && a.isReusable() == b.isReusable();
    }

    private static boolean enforceConsistentMetadata(Metadata existingMetadata, Metadata newMetadata, Tag ... tags) {
        if (!Registry.metadataMatches(existingMetadata, newMetadata)) {
            throw new IllegalArgumentException("New metric " + new MetricID(newMetadata.getName(), tags) + " with metadata " + newMetadata + " conflicts with a metric already registered with metadata " + existingMetadata);
        }
        return true;
    }

    private static <T extends HelidonMetric> boolean enforceConsistentMetadata(T existingMetric, Metadata newMetadata, Tag ... tags) {
        return Registry.enforceConsistentMetadata(existingMetric.metadata(), newMetadata, tags);
    }

    private static boolean enforceConsistentMetadataType(Metadata existingMetadata, MetricType newType, Tag ... tags) {
        if (!existingMetadata.getTypeRaw().equals((Object)newType)) {
            throw new IllegalArgumentException("Attempting to register a new metric " + new MetricID(existingMetadata.getName(), tags) + " of type " + newType.toString() + " found pre-existing metadata with conflicting type " + existingMetadata.getTypeRaw().toString());
        }
        return true;
    }

    private synchronized <T extends HelidonMetric> T getOrRegisterMetric(Metadata newMetadata, BiFunction<String, Metadata, T> metricFactory, Class<T> clazz, Tag ... tags) throws IllegalArgumentException {
        String metricName = newMetadata.getName();
        return (T)this.getOptionalMetric(metricName, clazz, tags).filter(existingMetric -> Registry.enforceConsistentMetadata(existingMetric, newMetadata, tags)).orElseGet(() -> {
            Metadata metadata = this.getOrRegisterMetadata(metricName, newMetadata, tags);
            return this.registerMetric(metricName, (HelidonMetric)metricFactory.apply(this.type.getName(), metadata), tags);
        });
    }

    private synchronized <T extends HelidonMetric> T getOrRegisterMetric(String metricName, BiFunction<String, Metadata, T> metricFactory, Class<T> clazz, Tag ... tags) {
        MetricType newType = METRIC_TO_TYPE_MAP.get(clazz);
        return (T)this.getOptionalMetric(metricName, clazz, tags).orElseGet(() -> {
            Metadata metadata = this.getOrRegisterMetadata(metricName, newType, () -> new HelidonMetadata(metricName, newType), tags);
            return this.registerMetric(metricName, (HelidonMetric)metricFactory.apply(this.type.getName(), metadata), tags);
        });
    }

    private synchronized <T extends Metric> T registerUniqueMetric(String metricName, T metric) throws IllegalArgumentException {
        this.enforceMetricUniqueness(metricName);
        MetricType metricType = MetricType.from(metric.getClass());
        Metadata metadata = this.getOrRegisterMetadata(metricName, metricType, () -> new HelidonMetadata(metricName, metricType), NO_TAGS);
        this.registerMetric(metricName, this.toImpl(metadata, metric), NO_TAGS);
        return metric;
    }

    private synchronized <T extends Metric> T registerUniqueMetric(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        String metricName = metadata.getName();
        this.enforceMetricUniqueness(metricName, tags);
        metadata = this.getOrRegisterMetadata(metricName, metadata, tags);
        this.registerMetric(metricName, this.toImpl(metadata, metric), tags);
        return metric;
    }

    private boolean enforceMetricUniqueness(String metricName) {
        return this.enforceMetricUniqueness(new MetricID(metricName));
    }

    private boolean enforceMetricUniqueness(String metricName, Tag ... tags) {
        return this.enforceMetricUniqueness(new MetricID(metricName, tags));
    }

    private boolean enforceMetricUniqueness(MetricID metricID) {
        if (this.allMetrics.containsKey(metricID)) {
            throw new IllegalArgumentException("Attempt to reregister the existing metric " + metricID);
        }
        return true;
    }

    private <T extends HelidonMetric, U extends HelidonMetric> U toType(T m1, Class<U> clazz) {
        MetricType type2;
        MetricType type1 = Registry.toType(m1);
        if (type1 == (type2 = Registry.toType(clazz))) {
            return (U)((HelidonMetric)clazz.cast(m1));
        }
        throw new IllegalArgumentException("Metric types " + type1.toString() + " and " + type2.toString() + " do not match");
    }

    private synchronized Metadata getOrRegisterMetadata(String metricName, Metadata newMetadata, Tag ... tags) {
        return this.getOptionalMetadata(metricName).filter(existingMetadata -> Registry.enforceConsistentMetadata(existingMetadata, newMetadata, tags)).orElseGet(() -> this.registerMetadata(newMetadata));
    }

    private synchronized Metadata getOrRegisterMetadata(String metricName, MetricType newMetricType, Supplier<Metadata> metadataFactory, Tag ... tags) {
        return this.getOptionalMetadata(metricName).filter(existingMetadata -> Registry.enforceConsistentMetadataType(existingMetadata, newMetricType, tags)).orElseGet(() -> this.registerMetadata((Metadata)metadataFactory.get()));
    }

    private Optional<Metadata> getOptionalMetadata(String name) {
        return Optional.ofNullable(this.allMetadata.get(name));
    }

    private Metadata registerMetadata(Metadata metadata) {
        this.allMetadata.put(metadata.getName(), metadata);
        return metadata;
    }

    private synchronized <T extends HelidonMetric> T registerMetric(String metricName, T metric, Tag ... tags) {
        MetricID metricID = new MetricID(metricName, tags);
        this.allMetrics.put(metricID, metric);
        List<MetricID> metricIDsWithSameName = this.allMetricIDsByName.get(metricName);
        if (metricIDsWithSameName == null) {
            metricIDsWithSameName = new ArrayList<MetricID>();
            this.allMetricIDsByName.put(metricName, metricIDsWithSameName);
        }
        metricIDsWithSameName.add(metricID);
        return metric;
    }

    private <T extends Metric> HelidonMetric toImpl(Metadata metadata, T metric) {
        MetricType metricType = Registry.deriveType(metadata.getTypeRaw(), metric);
        switch (metricType) {
            case COUNTER: {
                return HelidonCounter.create(this.type.getName(), metadata, (Counter)metric);
            }
            case GAUGE: {
                return HelidonGauge.create(this.type.getName(), metadata, (Gauge)metric);
            }
            case HISTOGRAM: {
                return HelidonHistogram.create(this.type.getName(), metadata, (Histogram)metric);
            }
            case METERED: {
                return HelidonMeter.create(this.type.getName(), metadata, (Meter)metric);
            }
            case TIMER: {
                return HelidonTimer.create(this.type.getName(), metadata, (Timer)metric);
            }
            case CONCURRENT_GAUGE: {
                return HelidonConcurrentGauge.create(this.type.getName(), metadata, (ConcurrentGauge)metric);
            }
        }
        throw new IllegalArgumentException("Unexpected metric type " + metricType + ": " + metric.getClass().getName());
    }

    private static MetricType deriveType(MetricType candidateType, Metric metric) {
        if (candidateType != MetricType.INVALID) {
            return candidateType;
        }
        return Stream.of(Counter.class, Gauge.class, Histogram.class, Meter.class, Timer.class, ConcurrentGauge.class).filter(clazz -> clazz.isInstance(metric)).map(MetricType::from).findFirst().orElse(MetricType.INVALID);
    }

    private static <T extends Metric> HelidonMetadata toMetadata(String name, T metric) {
        return new HelidonMetadata(name, Registry.toType(metric));
    }

    private static MetricType toType(Metric metric) {
        Class<?> clazz = metric.getClass();
        do {
            Optional<Class> optionalClass;
            if (!(optionalClass = Arrays.stream(clazz.getInterfaces()).filter(Metric.class::isAssignableFrom).findFirst()).isPresent()) continue;
            clazz = optionalClass.get();
            break;
        } while ((clazz = clazz.getSuperclass()) != null);
        return MetricType.from(clazz == null ? metric.getClass() : clazz);
    }

    private static <T extends HelidonMetric> MetricType toType(Class<T> clazz) {
        return METRIC_TO_TYPE_MAP.getOrDefault(clazz, MetricType.INVALID);
    }

    private synchronized <V> SortedMap<MetricID, V> getSortedMetrics(MetricFilter filter, Class<V> metricClass) {
        Map<MetricID, Object> collected = this.allMetrics.entrySet().stream().filter(it -> metricClass.isAssignableFrom(((HelidonMetric)it.getValue()).getClass())).filter(it -> filter.matches((MetricID)it.getKey(), (Metric)it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> metricClass.cast(it.getValue())));
        return new TreeMap<MetricID, Object>(collected);
    }

    private static Tag[] toTags(Map<String, String> tags) {
        return tags.entrySet().stream().map(entry -> new Tag((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).toArray(new Tag[0]);
    }

    private static Map<Class<? extends HelidonMetric>, MetricType> prepareMetricToTypeMap() {
        HashMap<Class<? extends HelidonMetric>, MetricType> result = new HashMap<Class<? extends HelidonMetric>, MetricType>();
        result.put(HelidonConcurrentGauge.class, MetricType.CONCURRENT_GAUGE);
        result.put(HelidonCounter.class, MetricType.COUNTER);
        result.put(HelidonGauge.class, MetricType.GAUGE);
        result.put(HelidonHistogram.class, MetricType.HISTOGRAM);
        result.put(HelidonMeter.class, MetricType.METERED);
        result.put(HelidonTimer.class, MetricType.TIMER);
        return result;
    }
}

