/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.metrics.InternalBridge;
import io.helidon.metrics.HelidonConcurrentGauge;
import io.helidon.metrics.HelidonCounter;
import io.helidon.metrics.HelidonGauge;
import io.helidon.metrics.HelidonHistogram;
import io.helidon.metrics.HelidonMetadata;
import io.helidon.metrics.HelidonMeter;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.HelidonTimer;
import io.helidon.metrics.InternalMetricIDImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class Registry
extends MetricRegistry
implements InternalBridge.MetricRegistry {
    private static final Tag[] NO_TAGS = new Tag[0];
    private static final Map<Class<? extends HelidonMetric>, MetricType> METRIC_TO_TYPE_MAP = Registry.prepareMetricToTypeMap();
    private final MetricRegistry.Type type;
    private final Map<MetricID, HelidonMetric> allMetrics = new ConcurrentHashMap<MetricID, HelidonMetric>();
    private final Map<String, List<MetricID>> allMetricIDsByName = new ConcurrentHashMap<String, List<MetricID>>();
    private final Map<String, Metadata> allMetadata = new ConcurrentHashMap<String, Metadata>();

    protected Registry(MetricRegistry.Type type) {
        this.type = type;
    }

    public static Registry create(MetricRegistry.Type type) {
        return new Registry(type);
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        Metadata metadata = this.getOrCreateMetadata(name, metric);
        return (T)this.reuseOrRegisterMetric(new MetricID(name), this.toImpl(metadata, metric));
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(metadata, metric, NO_TAGS);
    }

    public <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        metadata = this.checkAgainstExistingMetadataOrRegister(metadata, tags);
        return (T)this.reuseOrRegisterMetric(new MetricID(metadata.getName(), tags), this.toImpl(metadata, metric));
    }

    public Counter counter(String name) {
        return this.counter(name, NO_TAGS);
    }

    public Counter counter(Metadata metadata) {
        return this.counter(metadata, NO_TAGS);
    }

    public Counter counter(InternalBridge.Metadata metadata) {
        return this.counter(Registry.toMetadata(metadata));
    }

    public Counter counter(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.counter(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Counter counter(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonCounter::create, HelidonCounter.class, tags);
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonCounter::create, HelidonCounter.class, tags);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, NO_TAGS);
    }

    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata, NO_TAGS);
    }

    public Histogram histogram(InternalBridge.Metadata metadata) {
        return this.histogram(Registry.toMetadata(metadata));
    }

    public Histogram histogram(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.histogram(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Histogram histogram(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonHistogram::create, HelidonHistogram.class, tags);
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonHistogram::create, HelidonHistogram.class, tags);
    }

    public Meter meter(String name) {
        return this.meter(name, NO_TAGS);
    }

    public Meter meter(Metadata metadata) {
        return this.meter(metadata, NO_TAGS);
    }

    public Meter meter(InternalBridge.Metadata metadata) {
        return this.meter(Registry.toMetadata(metadata));
    }

    public Meter meter(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.meter(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Meter meter(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonMeter::create, HelidonMeter.class, tags);
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonMeter::create, HelidonMeter.class, tags);
    }

    public Timer timer(String name) {
        return this.timer(name, NO_TAGS);
    }

    public Timer timer(Metadata metadata) {
        return this.timer(metadata, NO_TAGS);
    }

    public Timer timer(InternalBridge.Metadata metadata) {
        return this.timer(Registry.toMetadata(metadata));
    }

    public Timer timer(InternalBridge.Metadata metadata, Map<String, String> tags) {
        return this.timer(Registry.toMetadata(metadata), Registry.toTags(tags));
    }

    public Timer timer(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonTimer::create, HelidonTimer.class, tags);
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonTimer::create, HelidonTimer.class, tags);
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return this.concurrentGauge(name, NO_TAGS);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return this.concurrentGauge(metadata, NO_TAGS);
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, HelidonConcurrentGauge::create, HelidonConcurrentGauge.class, tags);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, HelidonConcurrentGauge::create, HelidonConcurrentGauge.class, tags);
    }

    public boolean remove(String name) {
        boolean result = this.allMetricIDsByName.get(name).stream().map(metricID -> this.allMetrics.remove(metricID) != null).reduce((a, b) -> a != false || b != false).orElse(false);
        this.allMetricIDsByName.remove(name);
        this.allMetadata.remove(name);
        return result;
    }

    public boolean remove(MetricID metricID) {
        List<MetricID> likeNamedMetrics = this.allMetricIDsByName.get(metricID.getName());
        likeNamedMetrics.remove(metricID);
        if (likeNamedMetrics.isEmpty()) {
            this.allMetricIDsByName.remove(metricID.getName());
            this.allMetadata.remove(metricID.getName());
        }
        return this.allMetrics.remove(metricID) != null;
    }

    public void removeMatching(MetricFilter filter) {
        this.allMetrics.entrySet().stream().filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).map(entry -> this.remove((MetricID)entry.getKey())).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public SortedSet<String> getNames() {
        return this.allMetrics.keySet().stream().map(MetricID::getName).collect(Collectors.toCollection(TreeSet::new));
    }

    public SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.allMetrics.keySet());
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.getSortedMetrics(filter, Gauge.class);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Counter.class);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.getSortedMetrics(filter, Histogram.class);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Meter.class);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.getSortedMetrics(filter, Timer.class);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.getSortedMetrics(filter, ConcurrentGauge.class);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.allMetadata);
    }

    public Map<MetricID, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.allMetrics);
    }

    public Map<InternalBridge.MetricID, Metric> getBridgeMetrics(Predicate<? super Map.Entry<? extends InternalBridge.MetricID, ? extends Metric>> predicate) {
        HashMap<InternalBridge.MetricID, Metric> result = new HashMap<InternalBridge.MetricID, Metric>();
        this.allMetrics.entrySet().stream().map(Registry::toBridgeEntry).filter(predicate).forEach(entry -> result.put((InternalBridge.MetricID)entry.getKey(), (Metric)entry.getValue()));
        return result;
    }

    public Map<InternalBridge.MetricID, Metric> getBridgeMetrics() {
        return this.getBridgeMetrics(entry -> true);
    }

    public SortedMap<InternalBridge.MetricID, Gauge> getBridgeGauges() {
        return Registry.getBridgeMetrics(this.getGauges(), Gauge.class);
    }

    public SortedMap<InternalBridge.MetricID, Counter> getBridgeCounters() {
        return Registry.getBridgeMetrics(this.getCounters(), Counter.class);
    }

    public SortedMap<InternalBridge.MetricID, Histogram> getBridgeHistograms() {
        return Registry.getBridgeMetrics(this.getHistograms(), Histogram.class);
    }

    public SortedMap<InternalBridge.MetricID, Meter> getBridgeMeters() {
        return Registry.getBridgeMetrics(this.getMeters(), Meter.class);
    }

    public SortedMap<InternalBridge.MetricID, Timer> getBridgeTimers() {
        return Registry.getBridgeMetrics(this.getTimers(), Timer.class);
    }

    private static <T extends Metric> SortedMap<InternalBridge.MetricID, T> getBridgeMetrics(SortedMap<MetricID, T> metrics, Class<T> clazz) {
        return metrics.entrySet().stream().map(Registry::toBridgeEntry).filter(entry -> clazz.isAssignableFrom(((Metric)entry.getValue()).getClass())).collect(TreeMap::new, (map, entry) -> map.put((InternalBridge.MetricID)entry.getKey(), (Metric)clazz.cast(entry.getValue())), Map::putAll);
    }

    public <T extends Metric> T register(InternalBridge.Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(Registry.toMetadata(metadata), metric);
    }

    public <T extends Metric> T register(InternalBridge.MetricID metricID, T metric) throws IllegalArgumentException {
        return this.register((Metadata)Registry.toMetadata(metricID.getName(), metric), metric, Registry.toTags(metricID.getTags()));
    }

    private static Map.Entry<? extends InternalBridge.MetricID, ? extends Metric> toBridgeEntry(Map.Entry<? extends MetricID, ? extends Metric> entry) {
        return new AbstractMap.SimpleEntry<InternalMetricIDImpl, Metric>(new InternalMetricIDImpl(entry.getKey().getName(), entry.getKey().getTags()), entry.getValue());
    }

    public Optional<Metric> getMetric(String metricName) {
        return this.getOptionalMetricEntry(metricName).map(Map.Entry::getValue);
    }

    public Optional<Map.Entry<? extends InternalBridge.MetricID, ? extends Metric>> getBridgeMetric(String metricName) {
        return this.getOptionalMetricEntry(metricName).map(Registry::toBridgeEntry);
    }

    Stream<Map.Entry<MetricID, HelidonMetric>> stream() {
        return this.allMetrics.entrySet().stream();
    }

    public String type() {
        return this.type.getName();
    }

    public boolean empty() {
        return this.allMetrics.isEmpty();
    }

    public String toString() {
        return this.type() + ": " + this.allMetrics.size() + " metrics";
    }

    static Metadata toMetadata(InternalBridge.Metadata metadata) {
        MetadataBuilder builder = new MetadataBuilder();
        builder.withName(metadata.getName()).withDisplayName(metadata.getDisplayName()).withType(metadata.getTypeRaw());
        metadata.getDescription().ifPresent(arg_0 -> ((MetadataBuilder)builder).withDescription(arg_0));
        metadata.getUnit().ifPresent(arg_0 -> ((MetadataBuilder)builder).withUnit(arg_0));
        return (metadata.isReusable() ? builder.reusable() : builder.notReusable()).build();
    }

    Optional<Map.Entry<MetricID, HelidonMetric>> getOptionalMetricEntry(String metricName) {
        return this.getOptionalMetricWithIDsEntry(metricName).map(entry -> {
            MetricID metricID = (MetricID)((List)entry.getValue()).get(0);
            return new AbstractMap.SimpleImmutableEntry<MetricID, HelidonMetric>(metricID, this.allMetrics.get(metricID));
        });
    }

    <T extends HelidonMetric> Optional<T> getOptionalMetric(String metricName, Class<T> clazz, Tag ... tags) {
        return this.getOptionalMetric(new MetricID(metricName, tags), clazz);
    }

    <T extends HelidonMetric> Optional<T> getOptionalMetric(Metadata metadata, Class<T> clazz, Tag ... tags) {
        return this.getOptionalMetric(new MetricID(metadata.getName(), tags), clazz);
    }

    Optional<Map.Entry<HelidonMetric, List<MetricID>>> getOptionalMetricWithIDsEntry(String metricName) {
        List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
        if (metricIDs == null || metricIDs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AbstractMap.SimpleEntry<HelidonMetric, List<MetricID>>(this.allMetrics.get(metricIDs.get(0)), metricIDs));
    }

    <T extends HelidonMetric> Optional<T> getOptionalMetric(MetricID metricID, Class<T> clazz) {
        return Optional.ofNullable(this.allMetrics.get(metricID)).map(metric -> this.toType(metric, clazz));
    }

    MetricRegistry.Type registryType() {
        return this.type;
    }

    List<MetricID> metricIDsForName(String metricName) {
        return this.allMetricIDsByName.get(metricName);
    }

    static <T extends Metadata, U extends Metadata> boolean metadataMatches(T a, U b) {
        if (a == null && b == null || a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getName().equals(b.getName()) && a.getTypeRaw().equals((Object)b.getTypeRaw()) && (Registry.isFlexible(a) || Registry.isFlexible(b) || a.getDisplayName().equals(b.getDisplayName()) && Objects.equals(a.getDescription(), b.getDescription()) && Objects.equals(a.getUnit(), b.getUnit()) && a.isReusable() == b.isReusable());
    }

    private void enforceConsistentMetadata(MetricID metricID, Metadata m1, Metadata m2) {
        if (!Registry.metadataMatches(m1, m2)) {
            throw new IllegalArgumentException("New metric " + metricID + " with metadata " + m2 + " conflicts with a metric already registered with metadata " + m1);
        }
    }

    private void enforceReusabilityAllowed(MetricID metricID, Metadata m1, Metadata m2) {
        if (!m1.isReusable()) {
            throw new IllegalArgumentException("A metric " + metricID + " already registered as non-reusable");
        }
        if (!m2.isReusable()) {
            throw new IllegalArgumentException("A metric " + metricID + " already registered as reusable but a new registration requires non-reusable");
        }
    }

    private <T extends HelidonMetric> T getOrRegisterMetric(Metadata metadata, BiFunction<String, Metadata, T> metricFactory, Class<T> clazz, Tag ... tags) {
        Metadata metadataToUse = this.checkAgainstExistingMetadataOrRegister(metadata, tags);
        return (T)this.getOptionalMetric(metadata.getName(), clazz, tags).map(metric -> this.enforceReusability(metric, metadataToUse, metadata)).orElseGet(() -> this.reuseOrRegisterMetric(metadataToUse.getName(), (HelidonMetric)metricFactory.apply(this.type.getName(), metadata), tags));
    }

    private <T extends HelidonMetric> T getOrRegisterMetric(String metricName, BiFunction<String, Metadata, T> metricFactory, Class<T> clazz, Tag ... tags) {
        HelidonMetric metric = this.getOptionalMetric(metricName, clazz, tags).orElseGet(() -> {
            Metadata metadata = this.getOrCreateMetadata(metricName, METRIC_TO_TYPE_MAP.get(clazz));
            return this.reuseOrRegisterMetric(metricName, (HelidonMetric)metricFactory.apply(this.type.getName(), metadata), tags);
        });
        return (T)metric;
    }

    private Metadata getOrRegisterMetadata(String metricName, Supplier<HelidonMetadata> metadataSupplier) {
        Metadata result = this.allMetadata.get(metricName);
        if (result == null) {
            result = (Metadata)metadataSupplier.get();
            result = this.registerMetadata(result);
        }
        return result;
    }

    private Metadata getOrCreateMetadata(String metricName, MetricType metricType) {
        Metadata result = this.getOrRegisterMetadata(metricName, () -> new HelidonMetadata(metricName, metricType));
        if (metricType != result.getTypeRaw()) {
            throw new IllegalArgumentException("Attempting to register a new metric " + metricName + " of type " + metricType.toString() + " found pre-existing metadata with conflicting type " + result.getTypeRaw().toString());
        }
        return result;
    }

    private Metadata getOrCreateMetadata(String metricName, Metric metric) {
        Metadata result = this.getOrRegisterMetadata(metricName, () -> Registry.toMetadata(metricName, metric));
        return result;
    }

    private <T extends HelidonMetric> T enforceReusability(T metric, Metadata m1, Metadata m2) {
        if (!(metric.metadata().isReusable() || Registry.isFlexible(m1) || Registry.isFlexible(m2))) {
            throw new IllegalArgumentException("Attempting to re-register metric " + metric.getName() + " that is already registered as non-reusable");
        }
        return metric;
    }

    private Metadata checkAgainstExistingMetadataOrRegister(Metadata metadata, Tag ... tags) {
        String metricName = metadata.getName();
        Metadata existingMetadata = this.allMetadata.get(metricName);
        if (existingMetadata != null) {
            this.enforceConsistentMetadata(new MetricID(metadata.getName(), tags), existingMetadata, metadata);
            return existingMetadata;
        }
        return this.registerMetadata(metadata);
    }

    private <T extends HelidonMetric, U extends HelidonMetric> U toType(T m1, Class<U> clazz) {
        MetricType type2;
        MetricType type1 = Registry.toType(m1);
        if (type1 == (type2 = Registry.toType(clazz))) {
            return (U)((HelidonMetric)clazz.cast(m1));
        }
        throw new IllegalArgumentException("Metric types " + type1.toString() + " and " + type2.toString() + " do not match");
    }

    private Metadata registerMetadata(Metadata metadata) {
        this.allMetadata.put(metadata.getName(), metadata);
        return metadata;
    }

    private <T extends HelidonMetric> T reuseOrRegisterMetric(String metricName, T metric, Tag ... tags) {
        return this.reuseOrRegisterMetric(new MetricID(metricName, tags), metric);
    }

    private <T extends HelidonMetric> T reuseOrRegisterMetric(MetricID metricID, T metric) {
        HelidonMetric existingMetric = this.allMetrics.get(metricID);
        if (existingMetric != null) {
            this.enforceReusabilityAllowed(metricID, existingMetric.metadata(), metric.metadata());
            if (metric.getClass().isAssignableFrom(existingMetric.getClass())) {
                return (T)this.toType(existingMetric, metric.getClass());
            }
        }
        String metricName = metricID.getName();
        this.allMetrics.put(metricID, metric);
        List<MetricID> metricIDsWithSameName = this.allMetricIDsByName.get(metricName);
        if (metricIDsWithSameName == null) {
            metricIDsWithSameName = new ArrayList<MetricID>();
            this.allMetricIDsByName.put(metricName, metricIDsWithSameName);
        }
        metricIDsWithSameName.add(metricID);
        return metric;
    }

    private <T extends Metric> HelidonMetric toImpl(Metadata metadata, T metric) {
        switch (metadata.getTypeRaw()) {
            case COUNTER: {
                return HelidonCounter.create(this.type.getName(), metadata, (Counter)metric);
            }
            case GAUGE: {
                return HelidonGauge.create(this.type.getName(), metadata, (Gauge)metric);
            }
            case HISTOGRAM: {
                return HelidonHistogram.create(this.type.getName(), metadata, (Histogram)metric);
            }
            case METERED: {
                return HelidonMeter.create(this.type.getName(), metadata, (Meter)metric);
            }
            case TIMER: {
                return HelidonTimer.create(this.type.getName(), metadata, (Timer)metric);
            }
            case CONCURRENT_GAUGE: {
                return HelidonConcurrentGauge.create(this.type.getName(), metadata, (ConcurrentGauge)metric);
            }
        }
        throw new IllegalArgumentException("Unexpected metric type " + metadata.getType() + ": " + metric.getClass().getName());
    }

    private static <T extends Metric> HelidonMetadata toMetadata(String name, T metric) {
        return new HelidonMetadata(name, Registry.toType(metric));
    }

    private static MetricType toType(Metric metric) {
        Class<?> clazz = metric.getClass();
        do {
            Optional<Class> optionalClass;
            if (!(optionalClass = Arrays.stream(clazz.getInterfaces()).filter(Metric.class::isAssignableFrom).findFirst()).isPresent()) continue;
            clazz = optionalClass.get();
            break;
        } while ((clazz = clazz.getSuperclass()) != null);
        return MetricType.from(clazz == null ? metric.getClass() : clazz);
    }

    private static <T extends HelidonMetric> MetricType toType(Class<T> clazz) {
        return METRIC_TO_TYPE_MAP.getOrDefault(clazz, MetricType.INVALID);
    }

    private <V> SortedMap<MetricID, V> getSortedMetrics(MetricFilter filter, Class<V> metricClass) {
        Map<MetricID, Object> collected = this.allMetrics.entrySet().stream().filter(it -> metricClass.isAssignableFrom(((HelidonMetric)it.getValue()).getClass())).filter(it -> filter.matches((MetricID)it.getKey(), (Metric)it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> metricClass.cast(it.getValue())));
        return new TreeMap<MetricID, Object>(collected);
    }

    private static Tag[] toTags(Map<String, String> tags) {
        return tags.entrySet().stream().map(entry -> new Tag((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).toArray(new Tag[0]);
    }

    private static Map<Class<? extends HelidonMetric>, MetricType> prepareMetricToTypeMap() {
        HashMap<Class<? extends HelidonMetric>, MetricType> result = new HashMap<Class<? extends HelidonMetric>, MetricType>();
        result.put(HelidonConcurrentGauge.class, MetricType.CONCURRENT_GAUGE);
        result.put(HelidonCounter.class, MetricType.COUNTER);
        result.put(HelidonGauge.class, MetricType.GAUGE);
        result.put(HelidonHistogram.class, MetricType.HISTOGRAM);
        result.put(HelidonMeter.class, MetricType.METERED);
        result.put(HelidonTimer.class, MetricType.TIMER);
        return result;
    }

    private static boolean isFlexible(Metadata metadata) {
        return metadata instanceof HelidonMetadata && ((HelidonMetadata)((Object)HelidonMetadata.class.cast(metadata))).isFlexible();
    }
}

