/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import org.eclipse.microprofile.metrics.DefaultMetadata;
import org.eclipse.microprofile.metrics.MetricType;

public class HelidonMetadata
extends DefaultMetadata {
    private boolean isFlexible = false;

    public static HelidonMetadata newFlexible(String name, String displayName, String description, MetricType type, String unit) {
        HelidonMetadata result = new HelidonMetadata(name, displayName, description, type, unit, false);
        result.isFlexible = true;
        return result;
    }

    public HelidonMetadata(String name, MetricType type) {
        super(name, null, null, type, "none", true);
    }

    public HelidonMetadata(String name, String displayName, String description, MetricType type, String unit, boolean reusable) {
        super(name, displayName, description, type, unit, reusable);
    }

    public HelidonMetadata(String name, String displayName, String description, MetricType type, String unit) {
        super(name, displayName, description, type, unit, true);
    }

    public boolean isFlexible() {
        return this.isFlexible;
    }

    public String toString() {
        return String.format("%s, HelidonMetadata{isFlexible=%b}", super.toString(), this.isFlexible);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + (this.isFlexible ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HelidonMetadata)) {
            return false;
        }
        HelidonMetadata other = (HelidonMetadata)((Object)obj);
        if (this.isFlexible != other.isFlexible) {
            return false;
        }
        return super.equals(obj);
    }
}

