/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.HelidonConcurrentGauge;
import io.helidon.metrics.HelidonCounter;
import io.helidon.metrics.HelidonHistogram;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.HelidonTimer;
import io.helidon.metrics.Registry;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

final class FinalRegistry
extends Registry {
    private static final Tag[] EMPTY_TAGS = new Tag[0];
    private final Registry delegate;

    private FinalRegistry(Registry delegate) {
        super(delegate.registryType());
        this.delegate = delegate;
    }

    public static Registry create(Registry registry) {
        return new FinalRegistry(registry);
    }

    @Override
    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        throw this.cannotRegister(name);
    }

    @Override
    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        throw this.cannotRegister(metadata.getName());
    }

    @Override
    public <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        throw this.cannotRegister(metadata.getName());
    }

    @Override
    public Counter counter(String name) {
        return this.counter(name, EMPTY_TAGS);
    }

    @Override
    public Counter counter(Metadata metadata) {
        return this.counter(metadata.getName(), EMPTY_TAGS);
    }

    @Override
    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.counter(metadata.getName(), tags);
    }

    @Override
    public Counter counter(String name, Tag ... tags) {
        return this.delegate.getOptionalMetric(name, HelidonCounter.class, tags).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public Histogram histogram(String name) {
        return this.histogram(name, EMPTY_TAGS);
    }

    @Override
    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata.getName(), EMPTY_TAGS);
    }

    @Override
    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.histogram(metadata.getName(), tags);
    }

    @Override
    public Histogram histogram(String name, Tag ... tags) {
        return this.delegate.getOptionalMetric(name, HelidonHistogram.class, tags).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public Meter meter(String name) {
        return this.meter(name, EMPTY_TAGS);
    }

    @Override
    public Meter meter(Metadata metadata) {
        return this.meter(metadata.getName(), EMPTY_TAGS);
    }

    @Override
    public Meter meter(Metadata metadata, Tag ... tags) {
        return this.meter(metadata.getName(), tags);
    }

    @Override
    public Meter meter(String name, Tag ... tags) {
        return this.delegate.meter(name, tags);
    }

    @Override
    public Timer timer(String name) {
        return this.timer(name, EMPTY_TAGS);
    }

    @Override
    public Timer timer(Metadata metadata) {
        return this.timer(metadata.getName(), EMPTY_TAGS);
    }

    @Override
    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.timer(metadata.getName(), tags);
    }

    @Override
    public Timer timer(String name, Tag ... tags) {
        return this.delegate.getOptionalMetric(name, HelidonTimer.class, tags).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public ConcurrentGauge concurrentGauge(String name) {
        return this.concurrentGauge(name, EMPTY_TAGS);
    }

    @Override
    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return this.concurrentGauge(metadata.getName(), EMPTY_TAGS);
    }

    @Override
    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return this.concurrentGauge(metadata.getName(), tags);
    }

    @Override
    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return this.delegate.getOptionalMetric(name, HelidonConcurrentGauge.class, tags).orElseThrow(() -> this.cannotRegister(name));
    }

    @Override
    public boolean remove(String name) {
        throw this.cannotDelete(name);
    }

    @Override
    public boolean remove(MetricID metricID) {
        throw this.cannotDelete(metricID.getName());
    }

    @Override
    public void removeMatching(MetricFilter filter) {
        throw this.cannotDelete("Matching a filter: " + filter);
    }

    @Override
    public SortedSet<String> getNames() {
        return this.delegate.getNames();
    }

    @Override
    public SortedSet<MetricID> getMetricIDs() {
        return this.delegate.getMetricIDs();
    }

    @Override
    public SortedMap<MetricID, Gauge> getGauges() {
        return this.delegate.getGauges();
    }

    @Override
    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.delegate.getGauges(filter);
    }

    @Override
    public SortedMap<MetricID, Counter> getCounters() {
        return this.delegate.getCounters();
    }

    @Override
    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.delegate.getCounters(filter);
    }

    @Override
    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.delegate.getHistograms();
    }

    @Override
    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.delegate.getHistograms(filter);
    }

    @Override
    public SortedMap<MetricID, Meter> getMeters() {
        return this.delegate.getMeters();
    }

    @Override
    public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.delegate.getMeters(filter);
    }

    @Override
    public SortedMap<MetricID, Timer> getTimers() {
        return this.delegate.getTimers();
    }

    @Override
    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.delegate.getTimers(filter);
    }

    @Override
    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.delegate.getConcurrentGauges();
    }

    @Override
    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.delegate.getConcurrentGauges(filter);
    }

    @Override
    public Map<String, Metadata> getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public Map<MetricID, Metric> getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public Stream<Map.Entry<MetricID, HelidonMetric>> stream() {
        return this.delegate.stream();
    }

    @Override
    public String type() {
        return this.delegate.type();
    }

    @Override
    public boolean empty() {
        return this.delegate.empty();
    }

    @Override
    MetricRegistry.Type registryType() {
        return this.delegate.registryType();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private UnsupportedOperationException cannotDelete(String name) {
        return new UnsupportedOperationException("Cannot delete a metric \"" + name + "\" from final registry of type: " + this.type());
    }

    private UnsupportedOperationException cannotRegister(String name) {
        return new UnsupportedOperationException("Cannot register a metric \"" + name + "\" to a final registry of type: " + this.type());
    }
}

