/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.metrics.InternalBridge;
import io.helidon.config.Config;
import io.helidon.metrics.BaseRegistry;
import io.helidon.metrics.FinalRegistry;
import io.helidon.metrics.Registry;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.MetricRegistry;

public final class RegistryFactory
implements InternalBridge.MetricRegistry.RegistryFactory {
    private static final RegistryFactory INSTANCE = RegistryFactory.create();
    private final EnumMap<MetricRegistry.Type, Registry> registries = new EnumMap(MetricRegistry.Type.class);
    private final EnumMap<MetricRegistry.Type, Registry> publicRegistries = new EnumMap(MetricRegistry.Type.class);
    private final AtomicReference<Config> config;

    private RegistryFactory(Config config) {
        Registry registry = Registry.create(MetricRegistry.Type.APPLICATION);
        this.registries.put(MetricRegistry.Type.APPLICATION, registry);
        this.publicRegistries.put(MetricRegistry.Type.APPLICATION, registry);
        registry = Registry.create(MetricRegistry.Type.VENDOR);
        this.registries.put(MetricRegistry.Type.VENDOR, registry);
        this.publicRegistries.put(MetricRegistry.Type.VENDOR, FinalRegistry.create(registry));
        this.config = new AtomicReference<Config>(config);
    }

    public static RegistryFactory create() {
        return RegistryFactory.create(Config.empty());
    }

    public static RegistryFactory create(Config config) {
        return new RegistryFactory(config);
    }

    @Deprecated
    public static Supplier<RegistryFactory> getRegistryFactory() {
        return RegistryFactory::getInstance;
    }

    @Deprecated
    public static RegistryFactory createSeFactory(Config config) {
        return RegistryFactory.create(config);
    }

    public static RegistryFactory getInstance() {
        return INSTANCE;
    }

    public static RegistryFactory getInstance(Config config) {
        INSTANCE.update(config);
        return INSTANCE;
    }

    Registry getARegistry(MetricRegistry.Type type) {
        if (type == MetricRegistry.Type.BASE) {
            this.ensureBase();
        }
        return this.registries.get(type);
    }

    public MetricRegistry getRegistry(MetricRegistry.Type type) {
        if (type == MetricRegistry.Type.BASE) {
            this.ensureBase();
        }
        return this.publicRegistries.get(type);
    }

    public InternalBridge.MetricRegistry getBridgeRegistry(MetricRegistry.Type type) {
        return (InternalBridge.MetricRegistry)InternalBridge.MetricRegistry.class.cast(this.getRegistry(type));
    }

    private void update(Config config) {
        this.config.set(config);
    }

    private synchronized void ensureBase() {
        if (null == this.registries.get(MetricRegistry.Type.BASE)) {
            Registry registry = BaseRegistry.create(this.config.get());
            this.registries.put(MetricRegistry.Type.BASE, registry);
            this.publicRegistries.put(MetricRegistry.Type.BASE, FinalRegistry.create(registry));
        }
    }
}

