/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Supplier;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;

final class HelidonGauge<T>
extends MetricImpl
implements Gauge<T> {
    private final Supplier<T> value = () -> metric.getValue();

    private HelidonGauge(String registryType, Metadata metadata, Gauge<T> metric) {
        super(registryType, metadata);
    }

    static HelidonGauge<?> create(String registryType, Metadata metadata, Gauge<?> metric) {
        return new HelidonGauge(registryType, metadata, metric);
    }

    public T getValue() {
        return this.value.get();
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        return this.prometheusNameWithUnits(metricID.getName(), this.getUnits().getPrometheusUnit());
    }

    @Override
    public String prometheusValue() {
        return this.getUnits().convert(this.getValue()).toString();
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        T value = this.getValue();
        String nameWithTags = HelidonGauge.jsonFullKey(metricID);
        if (value instanceof String) {
            builder.add(nameWithTags, (String)value);
        } else if (value instanceof BigInteger) {
            builder.add(nameWithTags, (BigInteger)value);
        } else if (value instanceof BigDecimal) {
            builder.add(nameWithTags, (BigDecimal)value);
        } else if (value instanceof Integer) {
            builder.add(nameWithTags, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add(nameWithTags, ((Long)value).longValue());
        } else if (value instanceof Double) {
            builder.add(nameWithTags, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            builder.add(nameWithTags, ((Boolean)value).booleanValue());
        } else {
            builder.add(nameWithTags, String.valueOf(value));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonGauge that = (HelidonGauge)o;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue());
    }
}

