/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.serviceapi;

import io.helidon.common.http.Http;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.serviceapi.MetricsSupport;
import io.helidon.reactive.webserver.Handler;
import io.helidon.reactive.webserver.Routing;
import io.helidon.servicecommon.rest.HelidonRestServiceSupport;
import io.helidon.servicecommon.rest.RestServiceSettings;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class MinimalMetricsSupport
extends HelidonRestServiceSupport
implements MetricsSupport {
    static final String DISABLED_ENDPOINT_MESSAGE = "Metrics is disabled";
    private static final Handler DISABLED_ENDPOINT_HANDLER = (req, res) -> res.status(Http.Status.NOT_FOUND_404.code()).send((Object)DISABLED_ENDPOINT_MESSAGE);
    private final RestServiceSettings restServiceSettings;

    static Builder builder() {
        return new Builder();
    }

    static MinimalMetricsSupport create(RestServiceSettings restServiceSettings) {
        return new MinimalMetricsSupport(restServiceSettings);
    }

    public static void createEndpointForDisabledMetrics(String endpointContext, Routing.Rules serviceEndpointRoutingRules) {
        serviceEndpointRoutingRules.get(endpointContext, new Handler[]{DISABLED_ENDPOINT_HANDLER}).options(endpointContext, new Handler[]{DISABLED_ENDPOINT_HANDLER});
        Stream.of(MetricRegistry.Type.values()).map(Enum::name).map(String::toLowerCase).forEach(type -> Stream.of("", "/{metric}").map(suffix -> endpointContext + "/" + type + suffix).forEach(path -> serviceEndpointRoutingRules.get(path, new Handler[]{DISABLED_ENDPOINT_HANDLER}).options(path, new Handler[]{DISABLED_ENDPOINT_HANDLER})));
    }

    protected void postConfigureEndpoint(Routing.Rules defaultRules, Routing.Rules serviceEndpointRoutingRules) {
        MinimalMetricsSupport.createEndpointForDisabledMetrics(this.restServiceSettings.webContext(), serviceEndpointRoutingRules);
    }

    @Override
    public void prepareMetricsEndpoints(String endpointContext, Routing.Rules serviceEndpointRoutingRules) {
        MinimalMetricsSupport.createEndpointForDisabledMetrics(endpointContext, serviceEndpointRoutingRules);
    }

    @Override
    public void update(Routing.Rules rules) {
        this.configureEndpoint(rules, rules);
    }

    @Override
    public void configureVendorMetrics(String routingName, Routing.Rules routingRules) {
    }

    private MinimalMetricsSupport(RestServiceSettings restServiceSettings) {
        this(Logger.getLogger(MinimalMetricsSupport.class.getName()), restServiceSettings, "metrics");
    }

    private MinimalMetricsSupport(Builder builder) {
        this(Logger.getLogger(MinimalMetricsSupport.class.getName()), builder.restServiceSettingsBuilder.build(), "metrics");
    }

    private MinimalMetricsSupport(Logger logger, RestServiceSettings restServiceSettings, String serviceName) {
        super(logger, restServiceSettings, serviceName);
        this.restServiceSettings = restServiceSettings;
    }

    static class Builder
    implements MetricsSupport.Builder<Builder, MinimalMetricsSupport> {
        private RestServiceSettings.Builder restServiceSettingsBuilder = RestServiceSettings.builder().webContext("/metrics");

        Builder() {
        }

        @Override
        public Builder metricsSettings(MetricsSettings.Builder metricsSettingsBuilder) {
            return this;
        }

        @Override
        public Builder restServiceSettings(RestServiceSettings.Builder restServiceSettingsBuilder) {
            this.restServiceSettingsBuilder = restServiceSettingsBuilder;
            return this;
        }

        @Override
        public MinimalMetricsSupport build() {
            return new MinimalMetricsSupport(this);
        }
    }
}

