/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.serviceapi;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.serviceapi.MetricsSupport;
import io.helidon.metrics.serviceapi.MinimalMetricsSupportProviderImpl;
import io.helidon.metrics.serviceapi.spi.MetricsSupportProvider;
import io.helidon.servicecommon.rest.RestServiceSettings;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

class MetricsSupportManager {
    private static final Logger LOGGER = Logger.getLogger(MetricsSupportManager.class.getName());
    private static final LazyValue<MetricsSupportProvider<?, ?>> LAZY_PROVIDER = LazyValue.create(MetricsSupportManager::loadMetricsSupportProvider);

    private MetricsSupportManager() {
    }

    private static MetricsSupportProvider<?, ?> loadMetricsSupportProvider() {
        MetricsSupportProvider provider = (MetricsSupportProvider)HelidonServiceLoader.builder(ServiceLoader.load(MetricsSupportProvider.class)).addService((Object)new MinimalMetricsSupportProviderImpl(), 0.0).build().asList().get(0);
        LOGGER.log(Level.FINE, "MetricsSupport provider: {0}", provider.getClass().getName());
        return provider;
    }

    static MetricsSupport create() {
        return ((MetricsSupportProvider)LAZY_PROVIDER.get()).builder().restServiceSettings(MetricsSupport.defaultedMetricsRestServiceSettingsBuilder()).build();
    }

    static MetricsSupport.Builder<?, ?> builder() {
        return ((MetricsSupportProvider)LAZY_PROVIDER.get()).builder().restServiceSettings(MetricsSupport.defaultedMetricsRestServiceSettingsBuilder());
    }

    static MetricsSupport create(MetricsSettings metricsSettings, RestServiceSettings restServiceSettings) {
        return ((MetricsSupportProvider)LAZY_PROVIDER.get()).create(metricsSettings, restServiceSettings);
    }
}

