/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.serviceapi;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.serviceapi.MetricsSupportManager;
import io.helidon.servicecommon.rest.RestServiceSettings;
import io.helidon.servicecommon.rest.RestServiceSupport;
import io.helidon.webserver.Routing;
import io.helidon.webserver.Service;

public interface MetricsSupport
extends RestServiceSupport,
Service {
    public static MetricsSupport create() {
        return MetricsSupportManager.create();
    }

    public static MetricsSupport create(MetricsSettings metricsSettings, RestServiceSettings restServiceSettings) {
        return MetricsSupportManager.create(metricsSettings, restServiceSettings);
    }

    public static MetricsSupport create(MetricsSettings metricsSettings) {
        return MetricsSupport.create(metricsSettings, MetricsSupport.defaultedMetricsRestServiceSettingsBuilder().build());
    }

    public static MetricsSupport create(Config config) {
        return MetricsSupportManager.create(MetricsSettings.create((Config)config), MetricsSupport.defaultedMetricsRestServiceSettingsBuilder().config(config).build());
    }

    public static Builder<?, ?> builder() {
        return MetricsSupportManager.builder();
    }

    public static RestServiceSettings.Builder defaultedMetricsRestServiceSettingsBuilder() {
        return RestServiceSettings.builder().webContext("/metrics");
    }

    public void prepareMetricsEndpoints(String var1, Routing.Rules var2);

    public void configureEndpoint(Routing.Rules var1, Routing.Rules var2);

    public void configureVendorMetrics(String var1, Routing.Rules var2);

    public void update(Routing.Rules var1);

    @Configured
    public static interface Builder<B extends Builder<B, T>, T extends MetricsSupport>
    extends io.helidon.common.Builder<B, T> {
        public T build();

        public B metricsSettings(MetricsSettings.Builder var1);

        public B restServiceSettings(RestServiceSettings.Builder var1);
    }
}

