/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.prometheus;

import io.helidon.common.http.HttpMediaType;
import io.helidon.nima.servicecommon.HelidonFeatureSupport;
import io.helidon.nima.webserver.http.Handler;
import io.helidon.nima.webserver.http.HttpRules;
import io.helidon.nima.webserver.http.HttpService;
import io.helidon.nima.webserver.http.ServerRequest;
import io.helidon.nima.webserver.http.ServerResponse;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public final class PrometheusSupport
extends HelidonFeatureSupport {
    private static final System.Logger LOGGER = System.getLogger(PrometheusSupport.class.getName());
    private static final String DEFAULT_PATH = "/metrics";
    private static final HttpMediaType CONTENT_TYPE = HttpMediaType.create((String)"text/plain; version=0.0.4; charset=utf-8");
    private final CollectorRegistry collectorRegistry;
    private final String path;

    private PrometheusSupport(Builder builder) {
        super(LOGGER, (HelidonFeatureSupport.Builder)builder, "prometheus");
        this.collectorRegistry = builder.registry;
        this.path = builder.path;
    }

    private void configureRoutes(HttpRules rules) {
        rules.get(this.path, new Handler[]{this::process});
    }

    public Optional<HttpService> service() {
        return Optional.of(this::configureRoutes);
    }

    private void process(ServerRequest req, ServerResponse res) {
        HashSet filters = new HashSet(req.query().all("name[]", List::of));
        Enumeration mfs = this.collectorRegistry.filteredMetricFamilySamples(candidate -> {
            if (filters.isEmpty()) return true;
            if (!filters.stream().anyMatch(candidate::startsWith)) return false;
            return true;
        });
        res.headers().contentType(CONTENT_TYPE);
        res.send((Object)PrometheusSupport.compose(mfs));
    }

    private static String compose(Enumeration<Collector.MetricFamilySamples> mfs) {
        StringBuilder result = new StringBuilder();
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = mfs.nextElement();
            result.append("# HELP ").append(metricFamilySamples.name).append(' ');
            PrometheusSupport.appendEscapedHelp(result, metricFamilySamples.help);
            result.append('\n');
            result.append("# TYPE ").append(metricFamilySamples.name).append(' ').append(PrometheusSupport.typeString(metricFamilySamples.type)).append('\n');
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                result.append(sample.name);
                if (!sample.labelNames.isEmpty()) {
                    result.append('{');
                    for (int i = 0; i < sample.labelNames.size(); ++i) {
                        result.append((String)sample.labelNames.get(i)).append("=\"");
                        PrometheusSupport.appendEscapedLabelValue(result, (String)sample.labelValues.get(i));
                        result.append("\",");
                    }
                    result.append('}');
                }
                result.append(' ').append(Collector.doubleToGoString((double)sample.value)).append('\n');
            }
        }
        return result.toString();
    }

    private static void appendEscapedHelp(StringBuilder sb, String s) {
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static void appendEscapedLabelValue(StringBuilder sb, String s) {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static String typeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }

    public static PrometheusSupport create(CollectorRegistry collectorRegistry) {
        return PrometheusSupport.builder().collectorRegistry(collectorRegistry).build();
    }

    public static PrometheusSupport create() {
        return PrometheusSupport.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends HelidonFeatureSupport.Builder<Builder, PrometheusSupport> {
        private CollectorRegistry registry = CollectorRegistry.defaultRegistry;
        private String path = "/metrics";

        private Builder() {
            super("/");
        }

        public Builder collectorRegistry(CollectorRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder path(String path) {
            this.path = path == null || path.isEmpty() ? "/" : path;
            return this;
        }

        public PrometheusSupport build() {
            return new PrometheusSupport(this);
        }
    }
}

