/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.prometheus;

import io.helidon.common.http.MediaType;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Enumeration;
import java.util.HashSet;

public final class PrometheusSupport
implements Service {
    private static final String DEFAULT_PATH = "/metrics";
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"text/plain; version=0.0.4; charset=utf-8");
    private final CollectorRegistry collectorRegistry;
    private final String path;

    private PrometheusSupport(CollectorRegistry collectorRegistry, String path) {
        this.collectorRegistry = collectorRegistry == null ? CollectorRegistry.defaultRegistry : collectorRegistry;
        this.path = path == null ? DEFAULT_PATH : path;
    }

    public void update(Routing.Rules rules) {
        rules.get(this.path, new Handler[]{this::process});
    }

    private void process(ServerRequest req, ServerResponse res) {
        HashSet filters = new HashSet(req.queryParams().all("name[]"));
        Enumeration mfs = this.collectorRegistry.filteredMetricFamilySamples(filters);
        res.headers().contentType(CONTENT_TYPE);
        res.send((Object)PrometheusSupport.compose(mfs));
    }

    private static String compose(Enumeration<Collector.MetricFamilySamples> mfs) {
        StringBuilder result = new StringBuilder();
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = mfs.nextElement();
            result.append("# HELP ").append(metricFamilySamples.name).append(' ');
            PrometheusSupport.appendEscapedHelp(result, metricFamilySamples.help);
            result.append('\n');
            result.append("# TYPE ").append(metricFamilySamples.name).append(' ').append(PrometheusSupport.typeString(metricFamilySamples.type)).append('\n');
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                result.append(sample.name);
                if (!sample.labelNames.isEmpty()) {
                    result.append('{');
                    for (int i = 0; i < sample.labelNames.size(); ++i) {
                        result.append((String)sample.labelNames.get(i)).append("=\"");
                        PrometheusSupport.appendEscapedLabelValue(result, (String)sample.labelValues.get(i));
                        result.append("\",");
                    }
                    result.append('}');
                }
                result.append(' ').append(Collector.doubleToGoString((double)sample.value)).append('\n');
            }
        }
        return result.toString();
    }

    private static void appendEscapedHelp(StringBuilder sb, String s) {
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static void appendEscapedLabelValue(StringBuilder sb, String s) {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static String typeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }

    public static PrometheusSupport create(CollectorRegistry collectorRegistry) {
        return new PrometheusSupport(collectorRegistry, DEFAULT_PATH);
    }

    public static PrometheusSupport create() {
        return PrometheusSupport.create(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, PrometheusSupport> {
        private CollectorRegistry registry = CollectorRegistry.defaultRegistry;
        private String path;

        private Builder() {
        }

        public Builder collectorRegistry(CollectorRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder path(String path) {
            this.path = path == null || path.isEmpty() ? "/" : path;
            return this;
        }

        public PrometheusSupport build() {
            return new PrometheusSupport(this.registry, this.path == null ? PrometheusSupport.DEFAULT_PATH : this.path);
        }
    }
}

