/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.metrics.api;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;

/**
 * Config bean for KPI metrics configuration.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.codegen.BuilderCodegen", trigger = "io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfigBlueprint")
public interface KeyPerformanceIndicatorMetricsConfig extends KeyPerformanceIndicatorMetricsConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static KeyPerformanceIndicatorMetricsConfig.Builder builder() {
        return new KeyPerformanceIndicatorMetricsConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static KeyPerformanceIndicatorMetricsConfig.Builder builder(KeyPerformanceIndicatorMetricsConfig instance) {
        return KeyPerformanceIndicatorMetricsConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static KeyPerformanceIndicatorMetricsConfig create(Config config) {
        return KeyPerformanceIndicatorMetricsConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static KeyPerformanceIndicatorMetricsConfig create() {
        return KeyPerformanceIndicatorMetricsConfig.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link KeyPerformanceIndicatorMetricsConfig}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends KeyPerformanceIndicatorMetricsConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends KeyPerformanceIndicatorMetricsConfig> implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private boolean extended = false;
        private Config config;
        private Duration longRunningRequestThreshold = Duration.parse("PT10S");

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance. This method disables automatic service discovery.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(KeyPerformanceIndicatorMetricsConfig prototype) {
            extended(prototype.extended());
            longRunningRequestThreshold(prototype.longRunningRequestThreshold());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(KeyPerformanceIndicatorMetricsConfig.BuilderBase<?, ?> builder) {
            extended(builder.extended());
            longRunningRequestThreshold(builder.longRunningRequestThreshold());
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("extended").as(Boolean.class).ifPresent(this::extended);
            config.get("long-running-requests.threshold").as(Duration.class).ifPresent(this::longRunningRequestThreshold);
            return self();
        }

        /**
         * Whether KPI extended metrics are enabled.
         *
         * @param extended true if KPI extended metrics are enabled; false otherwise
         * @return updated builder instance
         * @see #extended()
         */
        public BUILDER extended(boolean extended) {
            this.extended = extended;
            return self();
        }

        /**
         * Threshold in ms that characterizes whether a request is long running.
         *
         * @param longRunningRequestThreshold threshold in ms indicating a long-running request
         * @return updated builder instance
         * @see #longRunningRequestThreshold()
         */
        public BUILDER longRunningRequestThreshold(Duration longRunningRequestThreshold) {
            Objects.requireNonNull(longRunningRequestThreshold);
            this.longRunningRequestThreshold = longRunningRequestThreshold;
            return self();
        }

        /**
         * Whether KPI extended metrics are enabled.
         *
         * @return the extended
         */
        public boolean extended() {
            return extended;
        }

        /**
         * Threshold in ms that characterizes whether a request is long running.
         *
         * @return the long running request threshold
         */
        public Duration longRunningRequestThreshold() {
            return longRunningRequestThreshold;
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "KeyPerformanceIndicatorMetricsConfigBuilder{"
                    + "extended=" + extended + ","
                    + "longRunningRequestThreshold=" + longRunningRequestThreshold
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class KeyPerformanceIndicatorMetricsConfigImpl implements KeyPerformanceIndicatorMetricsConfig {

            private final boolean extended;
            private final Duration longRunningRequestThreshold;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected KeyPerformanceIndicatorMetricsConfigImpl(KeyPerformanceIndicatorMetricsConfig.BuilderBase<?, ?> builder) {
                this.extended = builder.extended();
                this.longRunningRequestThreshold = builder.longRunningRequestThreshold();
            }

            @Override
            public boolean extended() {
                return extended;
            }

            @Override
            public Duration longRunningRequestThreshold() {
                return longRunningRequestThreshold;
            }

            @Override
            public String toString() {
                return "KeyPerformanceIndicatorMetricsConfig{"
                        + "extended=" + extended + ","
                        + "longRunningRequestThreshold=" + longRunningRequestThreshold
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KeyPerformanceIndicatorMetricsConfig other)) {
                    return false;
                }
                return extended == other.extended()
                    && Objects.equals(longRunningRequestThreshold, other.longRunningRequestThreshold());
            }

            @Override
            public int hashCode() {
                return Objects.hash(extended, longRunningRequestThreshold);
            }

        }

    }

    /**
     * Fluent API builder for {@link KeyPerformanceIndicatorMetricsConfig}.
     */
    class Builder extends KeyPerformanceIndicatorMetricsConfig.BuilderBase<KeyPerformanceIndicatorMetricsConfig.Builder, KeyPerformanceIndicatorMetricsConfig> implements io.helidon.common.Builder<KeyPerformanceIndicatorMetricsConfig.Builder, KeyPerformanceIndicatorMetricsConfig> {

        private Builder() {
        }

        @Override
        public KeyPerformanceIndicatorMetricsConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new KeyPerformanceIndicatorMetricsConfigImpl(this);
        }

        @Override
        public KeyPerformanceIndicatorMetricsConfig build() {
            return buildPrototype();
        }

    }

}
