/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.config.Config;
import io.helidon.metrics.api.Clock;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.HistogramSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactoryManager;
import io.helidon.metrics.api.NoOpMeter;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public interface MetricsFactory {
    public static MetricsFactory getInstance() {
        return MetricsFactoryManager.getMetricsFactory();
    }

    public static MetricsFactory getInstance(Config metricsConfigNode) {
        return MetricsFactoryManager.getMetricsFactory(metricsConfigNode);
    }

    public static void closeAll() {
        MetricsFactoryManager.closeAll();
    }

    public void close();

    public MeterRegistry globalRegistry();

    public MeterRegistry globalRegistry(MetricsConfig var1);

    public MeterRegistry globalRegistry(Consumer<Meter> var1, Consumer<Meter> var2, boolean var3);

    public MetricsConfig metricsConfig();

    public <B extends MeterRegistry.Builder<B, M>, M extends MeterRegistry> B meterRegistryBuilder();

    public MeterRegistry createMeterRegistry(MetricsConfig var1);

    public MeterRegistry createMeterRegistry(MetricsConfig var1, Consumer<Meter> var2, Consumer<Meter> var3);

    public MeterRegistry createMeterRegistry(Clock var1, MetricsConfig var2);

    public MeterRegistry createMeterRegistry(Clock var1, MetricsConfig var2, Consumer<Meter> var3, Consumer<Meter> var4);

    public Clock clockSystem();

    public Counter.Builder counterBuilder(String var1);

    public <T> FunctionalCounter.Builder<T> functionalCounterBuilder(String var1, T var2, Function<T, Long> var3);

    public DistributionStatisticsConfig.Builder distributionStatisticsConfigBuilder();

    public DistributionSummary.Builder distributionSummaryBuilder(String var1, DistributionStatisticsConfig.Builder var2);

    public <T> Gauge.Builder<Double> gaugeBuilder(String var1, T var2, ToDoubleFunction<T> var3);

    public <N extends Number> Gauge.Builder<N> gaugeBuilder(String var1, Supplier<N> var2);

    public Timer.Builder timerBuilder(String var1);

    public Timer.Sample timerStart();

    public Timer.Sample timerStart(MeterRegistry var1);

    public Timer.Sample timerStart(Clock var1);

    public Tag tagCreate(String var1, String var2);

    public HistogramSnapshot histogramSnapshotEmpty(long var1, double var3, double var5);

    default public Meter noOpMeter(Meter.Builder<?, ?> builder) {
        NoOpMeter.Builder noOpBuilder;
        if (builder instanceof Counter.Builder) {
            Counter.Builder cb = (Counter.Builder)builder;
            noOpBuilder = NoOpMeter.Counter.builder(cb.name());
        } else if (builder instanceof FunctionalCounter.Builder) {
            FunctionalCounter.Builder fcb = (FunctionalCounter.Builder)builder;
            noOpBuilder = NoOpMeter.FunctionalCounter.builder(fcb.name(), fcb.stateObject(), fcb.fn());
        } else if (builder instanceof DistributionSummary.Builder) {
            DistributionSummary.Builder sb = (DistributionSummary.Builder)builder;
            noOpBuilder = NoOpMeter.DistributionSummary.builder(sb.name());
        } else if (builder instanceof Gauge.Builder) {
            Gauge.Builder gb = (Gauge.Builder)builder;
            noOpBuilder = NoOpMeter.Gauge.builder(gb.name(), gb.supplier());
        } else if (builder instanceof Timer.Builder) {
            Timer.Builder tb = (Timer.Builder)builder;
            noOpBuilder = NoOpMeter.Timer.builder(tb.name());
        } else {
            throw new IllegalArgumentException("Unrecognized meter builder type " + builder.getClass().getName());
        }
        SystemTagsManager.instance().effectiveScope(builder.scope()).ifPresent(noOpBuilder::scope);
        return noOpBuilder.build();
    }
}

