/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.builder.api.Prototype;
import io.helidon.metrics.api.ScopeConfig;
import java.util.Objects;
import java.util.regex.Pattern;

class ScopeConfigSupport {
    private ScopeConfigSupport() {
    }

    @Prototype.PrototypeMethod
    static boolean isMeterEnabled(ScopeConfig scopeConfig, String name) {
        return scopeConfig.enabled() && scopeConfig.exclude().map(excludePattern -> !excludePattern.matcher(name).matches()).orElse(true) != false && scopeConfig.include().map(includePattern -> includePattern.matcher(name).matches()).orElse(true) != false;
    }

    @Prototype.BuilderMethod
    static void include(ScopeConfig.BuilderBase<?, ?> builderBase, String includeString) {
        Objects.requireNonNull(includeString, "include expression");
        builderBase.include(Pattern.compile(includeString));
    }

    @Prototype.BuilderMethod
    static void exclude(ScopeConfig.BuilderBase<?, ?> builderBase, String excludeString) {
        Objects.requireNonNull(excludeString, "exclude expression");
        builderBase.exclude(Pattern.compile(excludeString));
    }
}

