// This is a generated file (powered by Helidon). Do not edit or extend from this artifact as it is subject to change at any time!

package io.helidon.metrics.api;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;

/**
 * Configuration settings for a scope within the {@value MetricsConfigBlueprint#METRICS_CONFIG_KEY} config section.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.metrics.api.ScopeConfigBlueprint")
public interface ScopeConfig extends ScopeConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static ScopeConfig.Builder builder() {
        return new ScopeConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static ScopeConfig.Builder builder(ScopeConfig instance) {
        return ScopeConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static ScopeConfig create(Config config) {
        return ScopeConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static ScopeConfig create() {
        return ScopeConfig.builder().buildPrototype();
    }

    /**
     * Indicates whether the specified meter is enabled according to the scope configuration.
     *
     * @param name        meter name to check
     * @return whether the meter is enabled
     */
    boolean isMeterEnabled(String name);

    /**
     * Fluent API builder base for {@link ScopeConfig}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends ScopeConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ScopeConfig> implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private boolean enabled = true;
        private Config config;
        private Pattern exclude;
        private Pattern include;
        private String name;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(ScopeConfig prototype) {
            name(prototype.name());
            enabled(prototype.enabled());
            include(prototype.include());
            exclude(prototype.exclude());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(ScopeConfig.BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            enabled(builder.enabled());
            builder.include().ifPresent(this::include);
            builder.exclude().ifPresent(this::exclude);
            return self();
        }

        /**
         * Sets the include expression using a {@link java.lang.String} compiled automatically
         * into a {@link java.util.regex.Pattern}.
         *
         * @param includeString include string
         * @return updated builder instance
         */
        public BUILDER include(String includeString) {
            ScopeConfigSupport.include(this, includeString);
            return self();
        }

        /**
         * Sets the exclude expression using a {@link java.lang.String} compiled automatically
         * into a {@link java.util.regex.Pattern}.
         *
         * @param excludeString exclude string
         * @return updated builder instance
         */
        public BUILDER exclude(String excludeString) {
            ScopeConfigSupport.exclude(this, excludeString);
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("filter.include").as(Pattern.class).ifPresent(this::include);
            config.get("filter.exclude").as(Pattern.class).ifPresent(this::exclude);
            return self();
        }

        /**
         * Name of the scope to which the configuration applies.
         *
         * @param name scope name
         * @return updated builder instance
         * @see #name()
         */
        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return self();
        }

        /**
         * Whether the scope is enabled.
         *
         * @param enabled if the scope is enabled
         * @return updated builder instance
         * @see #enabled()
         */
        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #include()
         */
        public BUILDER clearInclude() {
            this.include = null;
            return self();
        }

        /**
         * Regular expression for meter names to include.
         *
         * @param include include expression
         * @return updated builder instance
         * @see #include()
         */
        public BUILDER include(Pattern include) {
            Objects.requireNonNull(include);
            this.include = include;
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #exclude()
         */
        public BUILDER clearExclude() {
            this.exclude = null;
            return self();
        }

        /**
         * Regular expression for meter names to exclude.
         *
         * @param exclude exclude expression
         * @return updated builder instance
         * @see #exclude()
         */
        public BUILDER exclude(Pattern exclude) {
            Objects.requireNonNull(exclude);
            this.exclude = exclude;
            return self();
        }

        /**
         * Name of the scope to which the configuration applies.
         *
         * @return the name
         */
        public Optional<String> name() {
            return Optional.ofNullable(name);
        }

        /**
         * Whether the scope is enabled.
         *
         * @return the enabled
         */
        public boolean enabled() {
            return enabled;
        }

        /**
         * Regular expression for meter names to include.
         *
         * @return the include
         */
        public Optional<Pattern> include() {
            return Optional.ofNullable(include);
        }

        /**
         * Regular expression for meter names to exclude.
         *
         * @return the exclude
         */
        public Optional<Pattern> exclude() {
            return Optional.ofNullable(exclude);
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "ScopeConfigBuilder{"
                    + "name=" + name + ","
                    + "enabled=" + enabled + ","
                    + "include=" + include + ","
                    + "exclude=" + exclude
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (name == null) {
                collector.fatal(getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        /**
         * Regular expression for meter names to include.
         *
         * @param include include expression
         * @return updated builder instance
         * @see #include()
         */
        BUILDER include(Optional<? extends Pattern> include) {
            Objects.requireNonNull(include);
            this.include = include.map(java.util.regex.Pattern.class::cast).orElse(this.include);
            return self();
        }

        /**
         * Regular expression for meter names to exclude.
         *
         * @param exclude exclude expression
         * @return updated builder instance
         * @see #exclude()
         */
        BUILDER exclude(Optional<? extends Pattern> exclude) {
            Objects.requireNonNull(exclude);
            this.exclude = exclude.map(java.util.regex.Pattern.class::cast).orElse(this.exclude);
            return self();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class ScopeConfigImpl implements ScopeConfig {

            private final boolean enabled;
            private final Optional<Pattern> exclude;
            private final Optional<Pattern> include;
            private final String name;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected ScopeConfigImpl(ScopeConfig.BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
                this.enabled = builder.enabled();
                this.include = builder.include();
                this.exclude = builder.exclude();
            }

            @Override
            public boolean isMeterEnabled(String name) {
                return ScopeConfigSupport.isMeterEnabled(this, name);
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public boolean enabled() {
                return enabled;
            }

            @Override
            public Optional<Pattern> include() {
                return include;
            }

            @Override
            public Optional<Pattern> exclude() {
                return exclude;
            }

            @Override
            public String toString() {
                return "ScopeConfig{"
                        + "name=" + name + ","
                        + "enabled=" + enabled + ","
                        + "include=" + include + ","
                        + "exclude=" + exclude
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ScopeConfig other)) {
                    return false;
                }
                return Objects.equals(name, other.name())
                        && enabled == other.enabled()
                        && Objects.equals(include, other.include())
                        && Objects.equals(exclude, other.exclude());
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, enabled, include, exclude);
            }

        }

    }

    /**
     * Fluent API builder for {@link ScopeConfig}.
     */
    class Builder extends ScopeConfig.BuilderBase<ScopeConfig.Builder, ScopeConfig> implements io.helidon.common.Builder<ScopeConfig.Builder, ScopeConfig> {

        private Builder() {
        }

        @Override
        public ScopeConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new ScopeConfigImpl(this);
        }

        @Override
        public ScopeConfig build() {
            return buildPrototype();
        }

    }

}
