/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.spi;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.ScopingConfig;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MetricsProgrammaticConfig {
    public static MetricsProgrammaticConfig instance() {
        return (MetricsProgrammaticConfig)Instance.INSTANCE.get();
    }

    default public Optional<String> scopeDefaultValue() {
        return Optional.empty();
    }

    default public Optional<String> scopeTagName() {
        return Optional.empty();
    }

    default public Optional<String> appTagName() {
        return Optional.empty();
    }

    default public Set<String> reservedTagNames() {
        return Stream.of(this.scopeTagName(), this.appTagName()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableSet());
    }

    default public MetricsConfig.Builder apply(MetricsConfig.Builder builder) {
        ScopingConfig.Builder scopingBuilder = builder.scoping().map(ScopingConfig::builder).orElseGet(ScopingConfig::builder);
        this.scopeDefaultValue().ifPresent(scopingBuilder::defaultValue);
        this.scopeTagName().ifPresent(scopingBuilder::tagName);
        this.appTagName().ifPresent(builder::appTagName);
        return (MetricsConfig.Builder)builder.scoping((Supplier<ScopingConfig>)((Object)scopingBuilder));
    }

    default public MetricsConfig apply(MetricsConfig metricsConfig) {
        return this.apply(MetricsConfig.builder(metricsConfig)).build();
    }

    public static class Instance {
        private static final LazyValue<MetricsProgrammaticConfig> INSTANCE = LazyValue.create(() -> (MetricsProgrammaticConfig)HelidonServiceLoader.builder(ServiceLoader.load(MetricsProgrammaticConfig.class)).addService((Object)new MetricsProgrammaticConfig(){}, Double.MIN_VALUE).build().asList().get(0));

        private Instance() {
        }
    }
}

