/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.spi.MetricsProgrammaticConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

class SystemTagsManagerImpl
implements SystemTagsManager {
    private static final LazyValue<Collection<MetricsProgrammaticConfig>> METRICS_CONFIG_OVERRIDES = LazyValue.create(() -> HelidonServiceLoader.create(ServiceLoader.load(MetricsProgrammaticConfig.class)).asList());
    private static SystemTagsManagerImpl instance = new SystemTagsManagerImpl();
    private static final Collection<Consumer<SystemTagsManager>> ON_CHANGE_SUBSCRIBERS = new ArrayList<Consumer<SystemTagsManager>>();
    private final List<Tag> systemTags;
    private final Set<String> systemTagNames = new HashSet<String>();
    private final Set<String> systemAndScopeTagNames = new HashSet<String>();
    private String scopeTagName;
    private String defaultScopeValue;

    private SystemTagsManagerImpl(MetricsConfig metricsConfig) {
        metricsConfig.tags().forEach(tag -> this.systemTagNames.add(tag.key()));
        this.systemAndScopeTagNames.addAll(this.systemTagNames);
        metricsConfig.scoping().tagName().ifPresent(this.systemAndScopeTagNames::add);
        ArrayList<Tag> result = new ArrayList<Tag>(metricsConfig.tags());
        metricsConfig.appTagName().filter(Predicate.not(String::isBlank)).ifPresent(tagNameToUse -> metricsConfig.appName().ifPresent(appNameToUse -> result.add(Tag.create(tagNameToUse, appNameToUse))));
        this.systemTags = List.copyOf(result);
        metricsConfig.scoping().tagName().ifPresent(tagNameToUse -> {
            this.scopeTagName = tagNameToUse;
        });
        this.defaultScopeValue = metricsConfig.scoping().defaultValue().orElse(null);
    }

    static void onChange(Consumer<SystemTagsManager> subscriber) {
        ON_CHANGE_SUBSCRIBERS.add(subscriber);
    }

    private SystemTagsManagerImpl() {
        this.systemTags = List.of();
        this.scopeTagName = "scope";
    }

    public static SystemTagsManager instance() {
        return instance;
    }

    static SystemTagsManagerImpl create(MetricsConfig metricsConfig) {
        instance = SystemTagsManagerImpl.createWithoutSaving(metricsConfig);
        return instance;
    }

    static SystemTagsManagerImpl instance(MetricsConfig metricsConfig) {
        instance = SystemTagsManagerImpl.createWithoutSaving(metricsConfig);
        ON_CHANGE_SUBSCRIBERS.forEach(sub -> sub.accept(SystemTagsManagerImpl.instance()));
        return instance;
    }

    static SystemTagsManagerImpl createWithoutSaving(MetricsConfig metricsConfig) {
        return new SystemTagsManagerImpl(metricsConfig);
    }

    static <T> Iterable<T> scopeIterable(String scopeTagName, String scope, BiFunction<String, String, T> factory) {
        return scopeTagName != null && !scopeTagName.isBlank() && scope != null ? List.of(factory.apply(scopeTagName, scope)) : List.of();
    }

    @Override
    public Optional<Tag> scopeTag(Optional<String> candidateScope) {
        return this.scopeTagName == null ? Optional.empty() : this.effectiveScope(candidateScope).map(sc -> Tag.create(this.scopeTagName, sc));
    }

    @Override
    public Iterable<Tag> withoutSystemTags(Iterable<Tag> tags) {
        return this.without(tags, this.systemTagNames);
    }

    @Override
    public Iterable<Tag> withoutSystemOrScopeTags(Iterable<Tag> tags) {
        return this.without(tags, this.systemAndScopeTagNames);
    }

    private Iterable<Tag> without(Iterable<Tag> tags, Collection<String> unwantedTagNames) {
        if (unwantedTagNames.isEmpty()) {
            return tags;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        tags.forEach(tag -> {
            if (!unwantedTagNames.contains(tag.key())) {
                result.add((Tag)tag);
            }
        });
        return result;
    }

    @Override
    public Iterable<Tag> withScopeTag(Iterable<Tag> tags, Optional<String> explicitScope) {
        if (this.scopeTagName == null) {
            return tags;
        }
        TreeMap<String, Tag> tagsMap = new TreeMap<String, Tag>();
        if (this.defaultScopeValue != null) {
            tagsMap.put(this.scopeTagName, Tag.create(this.scopeTagName, this.defaultScopeValue));
        }
        tags.forEach(tag -> tagsMap.put(tag.key(), (Tag)tag));
        explicitScope.ifPresent(s -> tagsMap.put(this.scopeTagName, Tag.create(this.scopeTagName, (String)explicitScope.get())));
        return tagsMap.values();
    }

    @Override
    public Iterable<Map.Entry<String, String>> withScopeTag(Iterable<Map.Entry<String, String>> tags, String scope) {
        if (this.scopeTagName == null) {
            return tags;
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        tags.forEach(tag -> result.put((String)tag.getKey(), (String)tag.getValue()));
        result.put(this.scopeTagName, scope);
        return result.entrySet();
    }

    @Override
    public Iterable<Tag> displayTags() {
        return List.copyOf(this.systemTags);
    }

    @Override
    public void assignScope(String validScope, Function<Tag, ?> tagSetter) {
        if (this.scopeTagName != null) {
            tagSetter.apply(Tag.create(this.scopeTagName, validScope));
        }
    }

    @Override
    public Optional<String> effectiveScope(Optional<String> candidateScope) {
        return candidateScope.isEmpty() && this.defaultScopeValue == null ? Optional.empty() : Optional.of(candidateScope.orElse(this.defaultScopeValue));
    }

    @Override
    public Optional<String> effectiveScope(Optional<String> explicitScope, Iterable<Tag> tags) {
        return explicitScope.or(() -> this.scopeFromTags(tags)).or(() -> Optional.ofNullable(this.defaultScopeValue));
    }

    @Override
    public Optional<String> scopeTagName() {
        return Optional.ofNullable(this.scopeTagName);
    }

    @Override
    public Collection<String> reservedTagNamesUsed(Collection<String> tagNames) {
        HashSet<String> reservedTagNamesUsed = new HashSet<String>(tagNames);
        reservedTagNamesUsed.retainAll(MetricsProgrammaticConfig.instance().reservedTagNames());
        return reservedTagNamesUsed;
    }

    private Optional<String> scopeFromTags(Iterable<Tag> tags) {
        return this.scopeTagName != null ? StreamSupport.stream(tags.spliterator(), false).filter(tag -> tag.key().equals(this.scopeTagName)).findAny().map(Tag::value) : Optional.empty();
    }

    static class MultiIterable<T>
    implements Iterable<T> {
        private final Iterable<T>[] iterables;

        private MultiIterable(Iterable<T> ... iterables) {
            if (iterables.length == 0) {
                throw new IllegalArgumentException("Must provide at least one Iterable");
            }
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int nextIndex = 0;
                private Iterator<T> current = this.nextIterator();

                @Override
                public boolean hasNext() {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    this.current = this.nextIterator();
                    return this.current.hasNext();
                }

                @Override
                public T next() {
                    return this.current.next();
                }

                private Iterator<T> nextIterator() {
                    while (this.nextIndex < iterables.length) {
                        Iterator candidateNextIterator = iterables[this.nextIndex].iterator();
                        if (candidateNextIterator.hasNext()) {
                            ++this.nextIndex;
                            return candidateNextIterator;
                        }
                        ++this.nextIndex;
                    }
                    return Collections.emptyIterator();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (Iterable<? super T> iterable : this.iterables) {
                iterable.forEach(action);
            }
        }
    }
}

