/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.Clock;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.NoOpMeter;
import io.helidon.metrics.api.NoOpWrapper;
import io.helidon.metrics.api.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

class NoOpMeterRegistry
implements MeterRegistry,
NoOpWrapper {
    NoOpMeterRegistry() {
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
    }

    @Override
    public List<Meter> meters() {
        return List.of();
    }

    @Override
    public Collection<Meter> meters(Predicate<Meter> filter) {
        return Set.of();
    }

    @Override
    public Iterable<Meter> meters(Iterable<String> scopeSelection) {
        return Set.of();
    }

    @Override
    public Clock clock() {
        return Clock.system();
    }

    @Override
    public Optional<Meter> remove(Meter.Id id) {
        return Optional.empty();
    }

    @Override
    public Optional<Meter> remove(Meter meter) {
        return Optional.empty();
    }

    @Override
    public Optional<Meter> remove(String name, Iterable<Tag> tags) {
        return Optional.empty();
    }

    @Override
    public Optional<Meter> remove(Meter.Id id, String scope) {
        return Optional.empty();
    }

    @Override
    public Optional<Meter> remove(String name, Iterable<Tag> tags, String scope) {
        return Optional.empty();
    }

    @Override
    public <M extends Meter> Optional<M> meter(Class<M> mClass, String name, Iterable<Tag> tags) {
        return Optional.empty();
    }

    @Override
    public boolean isDeleted(Meter meter) {
        return false;
    }

    @Override
    public boolean isMeterEnabled(String name, Map<String, String> tags, Optional<String> scope) {
        return true;
    }

    @Override
    public Iterable<String> scopes() {
        return Set.of();
    }

    @Override
    public <B extends Meter.Builder<B, M>, M extends Meter> M getOrCreate(B builder) {
        NoOpMeter.Builder b = (NoOpMeter.Builder)((Object)builder);
        return this.findOrRegister(NoOpMeter.Id.create(b.name(), b.tags()), builder);
    }

    @Override
    public MeterRegistry onMeterAdded(Consumer<Meter> listener) {
        return this;
    }

    @Override
    public MeterRegistry onMeterRemoved(Consumer<Meter> listener) {
        return this;
    }

    private <M extends Meter> Optional<M> find(Meter.Id id, Class<M> mClass) {
        return Optional.empty();
    }

    private <M extends Meter, B extends Meter.Builder<B, M>> M findOrRegister(Meter.Id id, B builder) {
        NoOpMeter.Builder noOpBuilder = (NoOpMeter.Builder)((Object)builder);
        return noOpBuilder.build();
    }

    static class Builder
    implements MeterRegistry.Builder<Builder, NoOpMeterRegistry> {
        Builder() {
        }

        public NoOpMeterRegistry build() {
            return new NoOpMeterRegistry();
        }

        @Override
        public Builder clock(Clock clock) {
            return (Builder)this.identity();
        }

        @Override
        public Builder metricsConfig(MetricsConfig metricsConfig) {
            return (Builder)this.identity();
        }

        @Override
        public Builder onMeterAdded(Consumer<Meter> addListener) {
            return (Builder)this.identity();
        }

        @Override
        public Builder onMeterRemoved(Consumer<Meter> removeListener) {
            return (Builder)this.identity();
        }
    }
}

