/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfigBlueprint;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfigBlueprint")
public interface KeyPerformanceIndicatorMetricsConfig
extends KeyPerformanceIndicatorMetricsConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KeyPerformanceIndicatorMetricsConfig instance) {
        return (Builder)KeyPerformanceIndicatorMetricsConfig.builder().from(instance);
    }

    public static KeyPerformanceIndicatorMetricsConfig create(Config config) {
        return ((Builder)KeyPerformanceIndicatorMetricsConfig.builder().config(config)).buildPrototype();
    }

    public static KeyPerformanceIndicatorMetricsConfig create() {
        return KeyPerformanceIndicatorMetricsConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, KeyPerformanceIndicatorMetricsConfig>
    implements io.helidon.common.Builder<Builder, KeyPerformanceIndicatorMetricsConfig> {
        private Builder() {
        }

        public KeyPerformanceIndicatorMetricsConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.KeyPerformanceIndicatorMetricsConfigImpl(this);
        }

        public KeyPerformanceIndicatorMetricsConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends KeyPerformanceIndicatorMetricsConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean extended = false;
        private Config config;
        private Duration longRunningRequestThreshold = Duration.parse("PT10S");

        protected BuilderBase() {
        }

        public BUILDER from(KeyPerformanceIndicatorMetricsConfig prototype) {
            this.extended(prototype.extended());
            this.longRunningRequestThreshold(prototype.longRunningRequestThreshold());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.extended(builder.extended());
            this.longRunningRequestThreshold(builder.longRunningRequestThreshold());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("extended").as(Boolean.class).ifPresent(this::extended);
            config.get("long-running-requests.threshold").as(Duration.class).ifPresent(this::longRunningRequestThreshold);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER extended(boolean extended) {
            this.extended = extended;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER longRunningRequestThreshold(Duration longRunningRequestThreshold) {
            Objects.requireNonNull(longRunningRequestThreshold);
            this.longRunningRequestThreshold = longRunningRequestThreshold;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean extended() {
            return this.extended;
        }

        public Duration longRunningRequestThreshold() {
            return this.longRunningRequestThreshold;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "KeyPerformanceIndicatorMetricsConfigBuilder{extended=" + this.extended + ",longRunningRequestThreshold=" + String.valueOf(this.longRunningRequestThreshold) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class KeyPerformanceIndicatorMetricsConfigImpl
        implements KeyPerformanceIndicatorMetricsConfig {
            private final boolean extended;
            private final Duration longRunningRequestThreshold;

            protected KeyPerformanceIndicatorMetricsConfigImpl(BuilderBase<?, ?> builder) {
                this.extended = builder.extended();
                this.longRunningRequestThreshold = builder.longRunningRequestThreshold();
            }

            @Override
            public boolean extended() {
                return this.extended;
            }

            @Override
            public Duration longRunningRequestThreshold() {
                return this.longRunningRequestThreshold;
            }

            public String toString() {
                return "KeyPerformanceIndicatorMetricsConfig{extended=" + this.extended + ",longRunningRequestThreshold=" + String.valueOf(this.longRunningRequestThreshold) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KeyPerformanceIndicatorMetricsConfig)) {
                    return false;
                }
                KeyPerformanceIndicatorMetricsConfig other = (KeyPerformanceIndicatorMetricsConfig)o;
                return this.extended == other.extended() && Objects.equals(this.longRunningRequestThreshold, other.longRunningRequestThreshold());
            }

            public int hashCode() {
                return Objects.hash(this.extended, this.longRunningRequestThreshold);
            }
        }
    }
}

