/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.MetricsProgrammaticSettings;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.api.SystemTagsManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

class SystemTagsManagerImpl
implements SystemTagsManager {
    private static SystemTagsManagerImpl instance = new SystemTagsManagerImpl();
    private final Map<String, String> systemTags;
    private final String scopeTagName;

    public static SystemTagsManager instance() {
        return instance;
    }

    static SystemTagsManagerImpl create(MetricsSettings metricsSettings) {
        instance = SystemTagsManagerImpl.createWithoutSaving(metricsSettings);
        return instance;
    }

    static SystemTagsManagerImpl createWithoutSaving(MetricsSettings metricsSettings) {
        return new SystemTagsManagerImpl(metricsSettings);
    }

    private SystemTagsManagerImpl(MetricsSettings metricsSettings) {
        HashMap<String, String> result = new HashMap<String, String>(metricsSettings.globalTags());
        String appTagName = MetricsProgrammaticSettings.instance().appTagName();
        if (metricsSettings.appTagValue() != null && appTagName != null && !appTagName.isBlank()) {
            result.put(appTagName, metricsSettings.appTagValue());
        }
        this.systemTags = Collections.unmodifiableMap(result);
        this.scopeTagName = MetricsProgrammaticSettings.instance().scopeTagName();
    }

    private SystemTagsManagerImpl() {
        this.systemTags = Collections.emptyMap();
        this.scopeTagName = "_testScope_";
    }

    @Override
    public Iterable<Map.Entry<String, String>> allTags(Map<String, String> explicitTags, String scope) {
        return new MultiIterable<Map.Entry<String, String>>(explicitTags.entrySet(), this.systemTags.entrySet(), this.scopeIterable(scope));
    }

    @Override
    public Iterable<Map.Entry<String, String>> allTags(MetricID metricID, String scope) {
        return new MultiIterable<Map.Entry<String, String>>(metricID.getTags().entrySet(), this.systemTags.entrySet(), this.scopeIterable(scope));
    }

    @Override
    public Iterable<Map.Entry<String, String>> allTags(Iterable<Map.Entry<String, String>> explicitTags, String scope) {
        return new MultiIterable<Map.Entry<String, String>>(explicitTags, this.systemTags.entrySet(), this.scopeIterable(scope));
    }

    @Override
    public Iterable<Map.Entry<String, String>> allTags(Iterable<Map.Entry<String, String>> explicitTags) {
        return new MultiIterable<Map.Entry<String, String>>(explicitTags, this.systemTags.entrySet());
    }

    @Override
    public Iterable<Map.Entry<String, String>> allTags(MetricID metricId) {
        return new MultiIterable<Map.Entry<String, String>>(metricId.getTags().entrySet(), this.systemTags.entrySet());
    }

    @Override
    public MetricID metricIdWithAllTags(MetricID original, String scope) {
        ArrayList tags = new ArrayList();
        List.of(original.getTags().entrySet(), this.systemTags.entrySet(), this.scopeIterable(scope)).forEach(iter -> iter.forEach(entry -> tags.add(new Tag((String)entry.getKey(), (String)entry.getValue()))));
        return new MetricID(original.getName(), tags.toArray(new Tag[0]));
    }

    private Iterable<Map.Entry<String, String>> scopeIterable(final String scope) {
        return () -> new Iterator<Map.Entry<String, String>>(){
            private boolean hasNext;
            {
                this.hasNext = SystemTagsManagerImpl.this.scopeTagName != null && !SystemTagsManagerImpl.this.scopeTagName.isBlank() && scope != null;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Map.Entry<String, String> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return new AbstractMap.SimpleImmutableEntry<String, String>(SystemTagsManagerImpl.this.scopeTagName, scope);
            }
        };
    }

    static class MultiIterable<T>
    implements Iterable<T> {
        private final Iterable<T>[] iterables;

        private MultiIterable(Iterable<T> ... iterables) {
            if (iterables.length == 0) {
                throw new IllegalArgumentException("Must provide at least one Iterable");
            }
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int nextIndex = 0;
                private Iterator<T> current = this.nextIterator();

                @Override
                public boolean hasNext() {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    this.current = this.nextIterator();
                    return this.current.hasNext();
                }

                @Override
                public T next() {
                    return this.current.next();
                }

                private Iterator<T> nextIterator() {
                    while (this.nextIndex < iterables.length) {
                        Iterator candidateNextIterator = iterables[this.nextIndex].iterator();
                        if (candidateNextIterator.hasNext()) {
                            ++this.nextIndex;
                            return candidateNextIterator;
                        }
                        ++this.nextIndex;
                    }
                    return Collections.emptyIterator();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (Iterable<? super T> iterable : this.iterables) {
                iterable.forEach(action);
            }
        }
    }
}

