/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.DerivedSample;
import io.helidon.metrics.api.ExemplarServiceManager;
import io.helidon.metrics.api.LabeledSample;

public interface Sample {
    public static Derived derived(double value, Labeled reference) {
        return new DerivedSample(value, reference);
    }

    public static Derived derived(double value) {
        return new DerivedSample(value, null);
    }

    public static Labeled labeled(double value) {
        return ExemplarServiceManager.isActive() ? new LabeledSample(value, ExemplarServiceManager.exemplarLabel(), System.currentTimeMillis()) : new LabeledSample(value, "", 0L);
    }

    public double doubleValue();

    public static interface Labeled
    extends Sample {
        public double value();

        public String label();

        public long timestamp();
    }

    public static interface Derived
    extends Sample {
        public static final Derived ZERO = new DerivedSample(0.0, null);

        public double value();

        public Labeled sample();
    }
}

