/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.metrics.api.RegistryFilterSettings;
import io.helidon.metrics.api.RegistrySettingsImpl;

public interface RegistrySettings {
    public static RegistrySettings create() {
        return RegistrySettings.builder().build();
    }

    public static RegistrySettings create(Config registrySettings) {
        return RegistrySettings.builder().config(registrySettings).build();
    }

    public static Builder builder() {
        return RegistrySettingsImpl.builder();
    }

    public boolean isEnabled();

    public boolean isMetricEnabled(String var1);

    public String value(String var1);

    @Configured(prefix="metrics.<metric-type>")
    public static interface Builder
    extends io.helidon.common.Builder<Builder, RegistrySettings> {
        public static final String ENABLED_CONFIG_KEY = "enabled";
        public static final String FILTER_CONFIG_KEY = "filter";
        public static final String SCOPE_CONFIG_KEY = "scope";

        @ConfiguredOption(key="enabled", value="true")
        public Builder enabled(boolean var1);

        @ConfiguredOption(key="filter", type=RegistryFilterSettings.class, description="Name filtering, featuring optional exclude and include settings")
        public Builder filterSettings(RegistryFilterSettings.Builder var1);

        public Builder config(Config var1);

        public boolean isEnabled();

        public RegistrySettings build();
    }
}

