/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.media.type.MediaType;
import io.helidon.config.Config;
import io.helidon.metrics.api.ComponentMetricsSettings;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.api.Registry;
import io.helidon.metrics.api.RegistryFactoryManager;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.Timer;

public interface RegistryFactory {
    public static final Set<Class<? extends Metric>> METRIC_TYPES = Set.of(Counter.class, Gauge.class, Histogram.class, Timer.class);

    public static RegistryFactory create() {
        return RegistryFactoryManager.create();
    }

    public static RegistryFactory create(MetricsSettings metricsSettings) {
        return RegistryFactoryManager.create(metricsSettings);
    }

    @Deprecated
    public static RegistryFactory create(Config config) {
        return RegistryFactoryManager.create(config);
    }

    public static RegistryFactory getInstance() {
        return RegistryFactoryManager.getInstance();
    }

    @Deprecated
    public static RegistryFactory getInstance(Config config) {
        return RegistryFactoryManager.getInstance(config);
    }

    public static RegistryFactory getInstance(MetricsSettings metricSettings) {
        return RegistryFactoryManager.getInstance(metricSettings);
    }

    public static RegistryFactory getInstance(ComponentMetricsSettings componentMetricsSettings) {
        return RegistryFactoryManager.getInstance(componentMetricsSettings);
    }

    public Registry getRegistry(String var1);

    default public void update(MetricsSettings metricsSettings) {
    }

    public boolean enabled();

    public Optional<?> scrape(MediaType var1, Iterable<String> var2, Iterable<String> var3);

    public Iterable<String> scopes();

    default public void start() {
    }

    default public void stop() {
    }
}

