/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.media.type.MediaType;
import io.helidon.metrics.api.NoOpMetricRegistry;
import io.helidon.metrics.api.Registry;
import io.helidon.metrics.api.RegistryFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class NoOpRegistryFactory
implements RegistryFactory {
    private static final Map<String, Registry> NO_OP_REGISTRIES = Registry.BUILT_IN_SCOPES.stream().collect(HashMap::new, (map, scope) -> map.put(scope, NoOpMetricRegistry.create(scope)), Map::putAll);

    public static NoOpRegistryFactory create() {
        return new NoOpRegistryFactory();
    }

    private NoOpRegistryFactory() {
    }

    @Override
    public Registry getRegistry(String scope) {
        return NO_OP_REGISTRIES.get(scope);
    }

    @Override
    public boolean enabled() {
        return false;
    }

    @Override
    public Optional<?> scrape(MediaType mediaType, Iterable<String> scopeSelection, Iterable<String> meterNameSelection) {
        throw new UnsupportedOperationException("NoOp registry does not support output");
    }

    @Override
    public Iterable<String> scopes() {
        return NO_OP_REGISTRIES.keySet();
    }
}

