/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.AbstractRegistry;
import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.MetricInstance;
import io.helidon.metrics.api.MetricsForMetadata;
import io.helidon.metrics.api.NoOpMetricFactory;
import io.helidon.metrics.api.NoOpMetricImpl;
import io.helidon.metrics.api.RegistrySettings;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

class NoOpMetricRegistry
extends AbstractRegistry {
    private static final RegistrySettings REGISTRY_SETTINGS = RegistrySettings.builder().enabled(false).build();

    private NoOpMetricRegistry(String scope) {
        super(scope, REGISTRY_SETTINGS, new NoOpMetricFactory());
    }

    public static NoOpMetricRegistry create(String scope) {
        return new NoOpMetricRegistry(scope);
    }

    @Override
    public boolean enabled(String metricName) {
        return false;
    }

    @Override
    public Optional<MetricInstance> find(String metricName) {
        return Optional.empty();
    }

    @Override
    public List<MetricInstance> list(String metricName) {
        return List.of();
    }

    @Override
    public List<MetricID> metricIdsByName(String name) {
        return List.of();
    }

    @Override
    public Optional<MetricsForMetadata> metricsByName(String name) {
        return Optional.empty();
    }

    @Override
    protected <T, R extends Number> Gauge<R> createGauge(Metadata metadata, T object, Function<T, R> func) {
        return NoOpMetricImpl.NoOpGaugeImpl.create(this.scope(), metadata, () -> (Number)func.apply(object));
    }

    @Override
    protected <R extends Number> Gauge<R> createGauge(Metadata metadata, Supplier<R> supplier) {
        return NoOpMetricImpl.NoOpGaugeImpl.create(this.scope(), metadata, supplier::get);
    }

    @Override
    protected void doRemove(MetricID metricId, HelidonMetric metric) {
    }

    @Override
    public <T> Counter counter(Metadata metadata, T origin, ToDoubleFunction<T> function, Tag ... tags) {
        return NoOpMetricImpl.NoOpFunctionalCounterImpl.create(this.scope(), metadata);
    }
}

