/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.AbstractMetric;
import io.helidon.metrics.api.NoOpMetric;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

class NoOpMetricImpl
extends AbstractMetric
implements NoOpMetric {
    protected NoOpMetricImpl(String registryType, Metadata metadata) {
        super(registryType, metadata);
    }

    static Snapshot snapshot() {
        return new NoOpSnapshot();
    }

    private static Timer.Context timerContext() {
        return new NoOpTimerImpl.Context(){};
    }

    static class NoOpSnapshot
    extends Snapshot {
        NoOpSnapshot() {
        }

        public long size() {
            return 0L;
        }

        public double getMax() {
            return 0.0;
        }

        public double getMean() {
            return 0.0;
        }

        public Snapshot.PercentileValue[] percentileValues() {
            return new Snapshot.PercentileValue[0];
        }

        public void dump(OutputStream output) {
        }
    }

    static class NoOpFunctionalCounterImpl
    extends NoOpMetricImpl
    implements Counter {
        static NoOpFunctionalCounterImpl create(String registryType, Metadata metadata) {
            return new NoOpFunctionalCounterImpl(registryType, metadata);
        }

        private NoOpFunctionalCounterImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void inc() {
            throw new UnsupportedOperationException();
        }

        public void inc(long n) {
            throw new UnsupportedOperationException();
        }

        public long getCount() {
            return 0L;
        }
    }

    static class NoOpTimerImpl
    extends NoOpMetricImpl
    implements Timer {
        static NoOpTimerImpl create(String registryType, Metadata metadata) {
            return new NoOpTimerImpl(registryType, metadata);
        }

        private NoOpTimerImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void update(Duration duration) {
        }

        public Duration getElapsedTime() {
            return Duration.ZERO;
        }

        public <T> T time(Callable<T> event) throws Exception {
            return event.call();
        }

        public void time(Runnable event) {
            event.run();
        }

        public Timer.Context time() {
            return NoOpMetricImpl.timerContext();
        }

        public long getCount() {
            return 0L;
        }

        public Snapshot getSnapshot() {
            return NoOpTimerImpl.snapshot();
        }

        static class Context
        implements Timer.Context {
            Context() {
            }

            public long stop() {
                return 0L;
            }

            public void close() {
            }
        }
    }

    static class NoOpHistogramImpl
    extends NoOpMetricImpl
    implements Histogram {
        static NoOpHistogramImpl create(String registryType, Metadata metadata) {
            return new NoOpHistogramImpl(registryType, metadata);
        }

        private NoOpHistogramImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void update(int value) {
        }

        public void update(long value) {
        }

        public long getCount() {
            return 0L;
        }

        public Snapshot getSnapshot() {
            return NoOpHistogramImpl.snapshot();
        }

        public long getSum() {
            return 0L;
        }
    }

    static abstract class NoOpGaugeImpl<N extends Number>
    extends NoOpMetricImpl
    implements Gauge<N> {
        static <N extends Number> NoOpGaugeImpl<N> create(String registryType, Metadata metadata, Supplier<N> supplier) {
            return new SupplierBased<N>(registryType, metadata, supplier);
        }

        static <N extends Number, T> NoOpGaugeImpl<N> create(String registryType, Metadata metadata, T target, Function<T, N> fn) {
            return new FunctionBased<N, T>(registryType, metadata, target, fn);
        }

        static <T> NoOpGaugeImpl<Double> create(String registryType, Metadata metadata, T target, ToDoubleFunction<T> fn) {
            return new DoubleFnBased<T>(registryType, metadata, target, fn);
        }

        private NoOpGaugeImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        private static class SupplierBased<N extends Number>
        extends NoOpGaugeImpl<N> {
            private final Supplier<N> supplier;

            private SupplierBased(String registryType, Metadata metadata, Supplier<N> supplier) {
                super(registryType, metadata);
                this.supplier = supplier;
            }

            public N getValue() {
                return (N)((Number)this.supplier.get());
            }
        }

        private static class FunctionBased<N extends Number, T>
        extends NoOpGaugeImpl<N> {
            private final T target;
            private final Function<T, N> fn;

            private FunctionBased(String registryType, Metadata metadata, T target, Function<T, N> fn) {
                super(registryType, metadata);
                this.target = target;
                this.fn = fn;
            }

            public N getValue() {
                return (N)((Number)this.fn.apply(this.target));
            }
        }

        private static class DoubleFnBased<T>
        extends NoOpGaugeImpl<Double> {
            private final T target;
            private final ToDoubleFunction<T> fn;

            private DoubleFnBased(String registryType, Metadata metadata, T target, ToDoubleFunction<T> fn) {
                super(registryType, metadata);
                this.target = target;
                this.fn = fn;
            }

            public Double getValue() {
                return this.fn.applyAsDouble(this.target);
            }
        }
    }

    static class NoOpCounterImpl
    extends NoOpMetricImpl
    implements Counter {
        static NoOpCounterImpl create(String registryType, Metadata metadata) {
            return new NoOpCounterImpl(registryType, metadata);
        }

        private NoOpCounterImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void inc() {
        }

        public void inc(long n) {
        }

        public long getCount() {
            return 0L;
        }
    }
}

