/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.metrics.api.BaseMetricsSettings;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsSettings;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.api.Registry;
import io.helidon.metrics.api.RegistrySettings;
import io.helidon.metrics.api.RegistrySettingsImpl;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MetricsSettingsImpl
implements MetricsSettings {
    private static final RegistrySettings DEFAULT_REGISTRY_SETTINGS = RegistrySettings.create();
    private final boolean isEnabled;
    private final KeyPerformanceIndicatorMetricsSettings kpiMetricsSettings;
    private final BaseMetricsSettings baseMetricsSettings;
    private final Map<String, RegistrySettings> registrySettings;
    private final Map<String, String> globalTags;
    private final String appTagValue;
    private final Config metricsSettingsConfig;

    private MetricsSettingsImpl(Builder builder) {
        this.metricsSettingsConfig = builder.metricsSettingsConfig;
        this.isEnabled = builder.isEnabled;
        this.kpiMetricsSettings = builder.kpiMetricsSettingsBuilder.build();
        this.baseMetricsSettings = (BaseMetricsSettings)builder.baseMetricsSettingsBuilder.build();
        this.registrySettings = builder.registrySettings;
        this.globalTags = builder.globalTags;
        this.appTagValue = builder.appTagValue;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public KeyPerformanceIndicatorMetricsSettings keyPerformanceIndicatorSettings() {
        return this.kpiMetricsSettings;
    }

    @Override
    public BaseMetricsSettings baseMetricsSettings() {
        return this.baseMetricsSettings;
    }

    @Override
    public boolean isMetricEnabled(String scope, String metricName) {
        if (!this.isEnabled) {
            return false;
        }
        RegistrySettings registrySettings = this.registrySettings.get(scope);
        return registrySettings == null || registrySettings.isMetricEnabled(metricName);
    }

    @Override
    public RegistrySettings registrySettings(String scope) {
        return this.registrySettings.getOrDefault(scope, DEFAULT_REGISTRY_SETTINGS);
    }

    @Override
    public Map<String, String> globalTags() {
        return this.globalTags;
    }

    @Override
    public String appTagValue() {
        return this.appTagValue;
    }

    @Override
    public String value(String key) {
        return this.metricsSettingsConfig != null ? (String)this.metricsSettingsConfig.get(key).asString().orElse(null) : null;
    }

    Map<String, RegistrySettings> registrySettings() {
        return this.registrySettings;
    }

    static class Builder
    implements MetricsSettings.Builder {
        private boolean isEnabled = true;
        private KeyPerformanceIndicatorMetricsSettings.Builder kpiMetricsSettingsBuilder = KeyPerformanceIndicatorMetricsSettings.builder();
        private BaseMetricsSettings.Builder baseMetricsSettingsBuilder = BaseMetricsSettings.builder();
        private final Map<String, RegistrySettings> registrySettings = Builder.prepareRegistrySettings();
        private Map<String, String> globalTags = Collections.emptyMap();
        private String appTagValue;
        private Config metricsSettingsConfig;

        private static Map<String, RegistrySettings> prepareRegistrySettings() {
            HashMap<String, RegistrySettings> result = new HashMap<String, RegistrySettings>();
            for (String predefinedScope : Registry.BUILT_IN_SCOPES) {
                result.put(predefinedScope, RegistrySettings.create());
            }
            return result;
        }

        protected Builder() {
        }

        protected Builder(MetricsSettings serviceSettings) {
            this.isEnabled = serviceSettings.isEnabled();
            this.kpiMetricsSettingsBuilder = KeyPerformanceIndicatorMetricsSettings.builder(serviceSettings.keyPerformanceIndicatorSettings());
            this.baseMetricsSettingsBuilder = BaseMetricsSettings.builder(serviceSettings.baseMetricsSettings());
            this.registrySettings.putAll(((MetricsSettingsImpl)serviceSettings).registrySettings());
        }

        @Override
        public MetricsSettingsImpl build() {
            return new MetricsSettingsImpl(this);
        }

        @Override
        public Builder enabled(boolean value) {
            this.isEnabled = value;
            return this;
        }

        @Override
        public Builder baseMetricsSettings(BaseMetricsSettings.Builder baseMetricsSettingsBuilder) {
            this.baseMetricsSettingsBuilder = baseMetricsSettingsBuilder;
            return this;
        }

        @Override
        public Builder config(Config metricsSettingsConfig) {
            this.metricsSettingsConfig = metricsSettingsConfig;
            this.baseMetricsSettingsBuilder.config(metricsSettingsConfig.get("base"));
            this.kpiMetricsSettingsBuilder.config(metricsSettingsConfig.get("key-performance-indicators"));
            metricsSettingsConfig.get("enabled").asBoolean().ifPresent(this::enabled);
            metricsSettingsConfig.get("registries").asList(ScopedRegistrySettingsImpl::create).ifPresent(this::addAllTypedRegistrySettings);
            metricsSettingsConfig.get("tags").as(Builder::globalTagsExpressionToMap).ifPresent(this::globalTags);
            metricsSettingsConfig.get("appName").asString().ifPresent(this::appTagValue);
            return this;
        }

        @Override
        public Builder keyPerformanceIndicatorSettings(KeyPerformanceIndicatorMetricsSettings.Builder kpiMetricsSettings) {
            this.kpiMetricsSettingsBuilder = kpiMetricsSettings;
            return this;
        }

        @Override
        public MetricsSettings.Builder registrySettings(String scope, RegistrySettings registrySettings) {
            this.registrySettings.put(scope, registrySettings);
            return this;
        }

        @Override
        public MetricsSettings.Builder globalTags(Map<String, String> globalTags) {
            this.globalTags = new HashMap<String, String>(globalTags);
            return this;
        }

        @Override
        public MetricsSettings.Builder appTagValue(String appTagValue) {
            this.appTagValue = appTagValue;
            return this;
        }

        private void addAllTypedRegistrySettings(List<ScopedRegistrySettingsImpl> typedRegistrySettingsList) {
            typedRegistrySettingsList.forEach(settings -> this.registrySettings.put(settings.scope, (RegistrySettings)settings));
        }

        private static Map<String, String> globalTagsExpressionToMap(Config globalTagExpression) {
            return Builder.globalTagsExpressionToMap((String)globalTagExpression.asString().get());
        }

        static Map<String, String> globalTagsExpressionToMap(String pairs) {
            HashMap<String, String> result = new HashMap<String, String>();
            ArrayList<CallSite> errorPairs = new ArrayList<CallSite>();
            String[] assignments = pairs.split("(?<!\\\\),");
            int position = 0;
            for (String assignment : assignments) {
                ArrayList<Object> errors = new ArrayList<Object>();
                if (assignment.isBlank()) {
                    errors.add("empty assignment at position " + position + ": " + assignment);
                } else {
                    String[] parts = assignment.split("(?<!\\\\)=");
                    if (parts.length != 2) {
                        errors.add("expected 2 parts separated by =; found '" + assignment + "' containing " + parts.length);
                    } else {
                        String name = parts[0];
                        String value = parts[1];
                        if (name.isBlank()) {
                            errors.add("missing tag name");
                        }
                        if (value.isBlank()) {
                            errors.add("missing tag value");
                        }
                        if (!name.matches("[A-Za-z_][A-Za-z_0-9]*")) {
                            errors.add("tag name must start with a letter and include only letters, digits, and underscores");
                        }
                        if (errors.isEmpty()) {
                            result.put(name, value.replace("\\,", ",").replace("\\=", "="));
                        }
                    }
                }
                if (!errors.isEmpty()) {
                    errorPairs.add((CallSite)((Object)("Position " + position + " with expression " + assignment + ": " + String.valueOf(errors))));
                }
                ++position;
            }
            if (!errorPairs.isEmpty()) {
                throw new IllegalArgumentException("Error(s) in global tag expression: " + String.valueOf(errorPairs));
            }
            return result;
        }

        private static class ScopedRegistrySettingsImpl
        extends RegistrySettingsImpl {
            private final String scope;

            static ScopedRegistrySettingsImpl create(Config registrySettingsConfig) {
                RegistrySettingsImpl.Builder builder = RegistrySettingsImpl.builder();
                builder.config(registrySettingsConfig);
                ConfigValue scopeValue = registrySettingsConfig.get("scope").asString();
                if (!scopeValue.isPresent()) {
                    throw new IllegalArgumentException("Missing metric registry scope in registry settings: " + String.valueOf(registrySettingsConfig));
                }
                return new ScopedRegistrySettingsImpl((String)scopeValue.get(), builder);
            }

            private ScopedRegistrySettingsImpl(String scope, RegistrySettingsImpl.Builder builder) {
                super(builder);
                this.scope = scope;
            }
        }
    }
}

