/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.metrics.api.BaseMetricsSettings;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsSettings;
import io.helidon.metrics.api.MetricsSettingsImpl;
import io.helidon.metrics.api.RegistrySettings;
import java.util.Map;

public interface MetricsSettings {
    public static MetricsSettings create() {
        return MetricsSettings.create(Config.create().get("metrics"));
    }

    public static MetricsSettings create(Config config) {
        return MetricsSettings.builder().config(config).build();
    }

    public static Builder builder() {
        return new MetricsSettingsImpl.Builder();
    }

    public static Builder builder(MetricsSettings metricsSettings) {
        return new MetricsSettingsImpl.Builder(metricsSettings);
    }

    public boolean isEnabled();

    public KeyPerformanceIndicatorMetricsSettings keyPerformanceIndicatorSettings();

    public BaseMetricsSettings baseMetricsSettings();

    public boolean isMetricEnabled(String var1, String var2);

    public RegistrySettings registrySettings(String var1);

    public Map<String, String> globalTags();

    public String appTagValue();

    public String value(String var1);

    @Configured(prefix="metrics")
    public static interface Builder
    extends io.helidon.common.Builder<Builder, MetricsSettings> {
        public static final String ENABLED_CONFIG_KEY = "enabled";
        public static final String METRICS_CONFIG_KEY = "metrics";
        public static final String BASE_CONFIG_KEY = "base";
        public static final String REGISTRIES_CONFIG_KEY = "registries";
        public static final String DEFAULT_CONTEXT = "/metrics";
        public static final String GLOBAL_TAGS_CONFIG_KEY = "tags";
        public static final String APP_TAG_CONFIG_KEY = "appName";

        public MetricsSettings build();

        @ConfiguredOption(key="enabled")
        public Builder enabled(boolean var1);

        public Builder config(Config var1);

        @ConfiguredOption(key="key-performance-indicators", type=KeyPerformanceIndicatorMetricsSettings.class)
        public Builder keyPerformanceIndicatorSettings(KeyPerformanceIndicatorMetricsSettings.Builder var1);

        @ConfiguredOption(key="base", type=BaseMetricsSettings.class)
        public Builder baseMetricsSettings(BaseMetricsSettings.Builder var1);

        @ConfiguredOption(key="registries", kind=ConfiguredOption.Kind.MAP, type=RegistrySettings.class)
        public Builder registrySettings(String var1, RegistrySettings var2);

        @ConfiguredOption(key="tags", kind=ConfiguredOption.Kind.MAP)
        public Builder globalTags(Map<String, String> var1);

        @ConfiguredOption(key="appName")
        public Builder appTagValue(String var1);
    }
}

