/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.FunctionalCounterRegistry;
import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.MetricInstance;
import io.helidon.metrics.api.MetricsForMetadata;
import io.helidon.metrics.api.MetricsProgrammaticSettings;
import io.helidon.metrics.api.NoOpMetricFactory;
import io.helidon.metrics.api.RegistryFactory;
import io.helidon.metrics.api.RegistrySettings;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.api.spi.MetricFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

class MetricStore
implements FunctionalCounterRegistry {
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Map<MetricID, HelidonMetric> allMetrics = new ConcurrentHashMap<MetricID, HelidonMetric>();
    private final Map<String, List<MetricID>> allMetricIDsByName = new ConcurrentHashMap<String, List<MetricID>>();
    private final Map<String, Metadata> allMetadata = new ConcurrentHashMap<String, Metadata>();
    private final Map<String, Set<String>> tagNameSets = new HashMap<String, Set<String>>();
    private final Map<String, Class<? extends Metric>> metricTypes = new HashMap<String, Class<? extends Metric>>();
    private volatile RegistrySettings registrySettings;
    private final MetricFactory metricFactory;
    private final MetricFactory noOpMetricFactory = new NoOpMetricFactory();
    private final String scope;
    private final BiConsumer<MetricID, HelidonMetric> doRemove;

    @Override
    public <T> Counter counter(Metadata metadata, T origin, ToDoubleFunction<T> function, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, Counter.class, origin, function, tags);
    }

    static MetricStore create(RegistrySettings registrySettings, MetricFactory metricFactory, String scope, BiConsumer<MetricID, HelidonMetric> doRemove) {
        return new MetricStore(registrySettings, metricFactory, scope, doRemove);
    }

    private MetricStore(RegistrySettings registrySettings, MetricFactory metricFactory, String scope, BiConsumer<MetricID, HelidonMetric> doRemove) {
        this.registrySettings = registrySettings;
        this.metricFactory = metricFactory;
        this.scope = scope;
        this.doRemove = doRemove;
    }

    void update(RegistrySettings registrySettings) {
        this.registrySettings = registrySettings;
    }

    <U extends Metric> U getOrRegisterMetric(MetricID metricID, Class<U> clazz) {
        return this.getOrRegisterMetric(metricID.getName(), clazz, () -> this.allMetrics.get(metricID), () -> metricID, () -> this.getConsistentMetadataLocked(metricID.getName()), new Tag[0]);
    }

    <U extends Metric> U getOrRegisterMetric(String metricName, Class<U> clazz, Tag ... tags) {
        return this.getOrRegisterMetric(metricName, clazz, () -> this.getMetricLocked(metricName, tags), () -> new MetricID(metricName, tags), () -> this.getConsistentMetadataLocked(metricName), tags);
    }

    <U extends Metric> U getOrRegisterMetric(Metadata newMetadata, Class<U> clazz, Tag ... tags) {
        Class<? extends Metric> newBaseType = MetricStore.baseMetricClass(clazz);
        return (U)this.writeAccess(() -> {
            this.enforceConsistentType(newMetadata.getName(), clazz);
            MetricID newMetricID = new MetricID(newMetadata.getName(), tags);
            this.checkOrStoreTagNames(newMetricID.getName(), newMetricID.getTags().keySet());
            this.checkOrStoreMetadata(newMetadata);
            HelidonMetric metric = this.getMetricLocked(newMetadata.getName(), tags);
            if (metric == null) {
                this.getConsistentMetadataLocked(newMetadata);
                metric = this.registerMetricLocked(newMetricID, this.createEnabledAwareMetric(clazz, newMetadata, tags));
                return (Metric)clazz.cast(metric);
            }
            this.ensureConsistentMetricTypes(metric, newBaseType, () -> newMetricID);
            return (Metric)clazz.cast(metric);
        });
    }

    <T, R extends Number> Gauge<R> getOrRegisterGauge(String name, T object, Function<T, R> func, Tag ... tags) {
        return this.getOrRegisterGauge(() -> this.getMetricLocked(name, tags), () -> this.getConsistentMetadataLocked(name), () -> new MetricID(name, tags), (Metadata metadata) -> this.metricFactory.gauge(this.scope, (Metadata)metadata, object, func, tags));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(String name, Supplier<R> valueSupplier, Tag ... tags) {
        return this.getOrRegisterGauge(() -> this.getMetricLocked(name, tags), () -> this.getConsistentMetadataLocked(name), () -> new MetricID(name, tags), (Metadata metadata) -> this.metricFactory.gauge(this.scope, (Metadata)metadata, valueSupplier, tags));
    }

    <T, R extends Number> Gauge<R> getOrRegisterGauge(Metadata newMetadata, T object, Function<T, R> valueFunction, Tag ... tags) {
        return this.getOrRegisterGauge(() -> this.getMetricLocked(newMetadata.getName(), tags), () -> this.getConsistentMetadataLocked(newMetadata), () -> new MetricID(newMetadata.getName(), tags), (Metadata metadata) -> this.metricFactory.gauge(this.scope, newMetadata, object, valueFunction, tags));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(Metadata newMetadata, Supplier<R> valueSupplier, Tag ... tags) {
        String metricName = newMetadata.getName();
        return this.getOrRegisterGauge(() -> this.getMetricLocked(metricName, tags), () -> this.getConsistentMetadataLocked(newMetadata), () -> new MetricID(metricName, tags), (Metadata metadata) -> this.metricFactory.gauge(this.scope, newMetadata, valueSupplier, tags));
    }

    <T, R extends Number> Gauge<R> getOrRegisterGauge(MetricID metricID, T object, Function<T, R> valueFunction) {
        return this.getOrRegisterGauge(() -> this.allMetrics.get(metricID), () -> this.allMetadata.get(metricID.getName()), () -> metricID, (Metadata metadata) -> this.metricFactory.gauge(this.scope, (Metadata)metadata, object, valueFunction, new Tag[0]));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(MetricID metricID, Supplier<R> valueSupplier) {
        return this.getOrRegisterGauge(() -> this.allMetrics.get(metricID), () -> this.allMetadata.get(metricID.getName()), () -> metricID, (Metadata metadata) -> this.metricFactory.gauge(this.scope, (Metadata)metadata, valueSupplier, new Tag[0]));
    }

    <T, U extends Metric> U getOrRegisterMetric(Metadata newMetadata, Class<U> clazz, T origin, ToDoubleFunction<T> function, Tag ... tags) {
        Class<? extends Metric> newBaseType = MetricStore.baseMetricClass(clazz);
        return (U)this.writeAccess(() -> {
            this.enforceConsistentType(newMetadata.getName(), newBaseType);
            MetricID newMetricID = new MetricID(newMetadata.getName(), tags);
            this.checkOrStoreTagNames(newMetricID.getName(), newMetricID.getTags().keySet());
            this.checkOrStoreMetadata(newMetadata);
            HelidonMetric metric = this.getMetricLocked(newMetadata.getName(), tags);
            if (metric == null) {
                this.getConsistentMetadataLocked(newMetadata);
                metric = this.registerMetricLocked(newMetricID, this.createEnabledAwareMetric(newBaseType, newMetadata, origin, function, tags));
                return (Metric)clazz.cast(metric);
            }
            this.ensureConsistentMetricTypes(metric, newBaseType, () -> newMetricID);
            return (Metric)clazz.cast(metric);
        });
    }

    private Set<String> checkOrStoreTagNames(String metricName, Set<String> tagNames) {
        HashSet<String> reservedTagNamesUsed = new HashSet<String>(tagNames);
        reservedTagNamesUsed.retainAll(MetricsProgrammaticSettings.instance().reservedTagNames());
        if (!reservedTagNamesUsed.isEmpty()) {
            throw new IllegalArgumentException("Program-specified tag names include reserved names: " + String.valueOf(reservedTagNamesUsed));
        }
        Set<String> currentTagNames = this.tagNameSets.get(metricName);
        if (currentTagNames == null) {
            return this.tagNameSets.put(metricName, tagNames);
        }
        MetricStore.enforceConsistentTagNames(metricName, currentTagNames, tagNames);
        return tagNames;
    }

    private static void enforceConsistentTagNames(String metricName, Set<String> existingTagNames, Set<String> newTagNames) {
        if (!existingTagNames.equals(newTagNames)) {
            throw new IllegalArgumentException(String.format("New tag names %s for metric %s conflict with existing tag names %s", newTagNames, metricName, existingTagNames));
        }
    }

    private Metadata checkOrStoreMetadata(Metadata candidateMetadata) {
        Metadata currentMetadata = this.allMetadata.get(candidateMetadata.getName());
        if (currentMetadata == null) {
            return this.allMetadata.put(candidateMetadata.getName(), candidateMetadata);
        }
        MetricStore.enforceConsistentMetadata(currentMetadata, candidateMetadata);
        return candidateMetadata;
    }

    private static void enforceConsistentMetadata(Metadata existingMetadata, Metadata newMetadata) {
        if (!MetricStore.metadataMatches(existingMetadata, newMetadata)) {
            throw new IllegalArgumentException("New metadata conflicts with existing metadata with the same name; existing: " + String.valueOf(existingMetadata) + ", new: " + String.valueOf(newMetadata));
        }
    }

    private static <T extends Metadata, U extends Metadata> boolean metadataMatches(T a, U b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getName().equals(b.getName()) && Objects.equals(a.getDescription(), b.getDescription()) && Objects.equals(a.getUnit(), b.getUnit());
    }

    private void enforceConsistentType(String metricName, Class<? extends Metric> newType) {
        Class<? extends Metric> metricType = this.metricTypes.get(metricName);
        if (metricType != null && !metricType.isAssignableFrom(newType)) {
            throw new IllegalArgumentException(String.format("Attempt to register metric %s of type %s but the name is already associated with a metric of type %s", metricName, newType.getName(), metricType.getName()));
        }
    }

    private static Class<? extends Metric> baseMetricClass(Class<?> clazz) {
        for (Class<? extends Metric> baseClass : RegistryFactory.METRIC_TYPES) {
            if (!baseClass.isAssignableFrom(clazz)) continue;
            return baseClass;
        }
        throw new IllegalArgumentException("Unable to map metric type " + clazz.getName() + " to one of " + String.valueOf(RegistryFactory.METRIC_TYPES));
    }

    private <R extends Number> Gauge<R> getOrRegisterGauge(Supplier<HelidonMetric> metricFinder, Supplier<Metadata> metadataFinder, Supplier<MetricID> metricIDSupplier, Function<Metadata, Gauge<R>> gaugeFactory) {
        return this.writeAccess(() -> {
            Metadata metadata = (Metadata)metadataFinder.get();
            this.enforceConsistentType(metadata.getName(), Gauge.class);
            HelidonMetric metric = (HelidonMetric)metricFinder.get();
            if (metric == null) {
                metric = this.registerMetricLocked((MetricID)metricIDSupplier.get(), this.createEnabledAwareGauge(metadata, gaugeFactory));
            }
            return (Gauge)metric;
        });
    }

    boolean remove(MetricID metricID) {
        return this.writeAccess(() -> {
            HelidonMetric doomedMetric;
            List<MetricID> metricIDsForName = this.allMetricIDsByName.get(metricID.getName());
            if (metricIDsForName == null) {
                return false;
            }
            metricIDsForName.remove(metricID);
            if (metricIDsForName.isEmpty()) {
                this.allMetricIDsByName.remove(metricID.getName());
                this.allMetadata.remove(metricID.getName());
                this.tagNameSets.remove(metricID.getName());
                this.metricTypes.remove(metricID.getName());
            }
            if ((doomedMetric = this.allMetrics.remove(metricID)) != null) {
                doomedMetric.markAsDeleted();
            }
            this.doRemove.accept(SystemTagsManager.instance().metricIdWithAllTags(metricID, this.scope), doomedMetric);
            return doomedMetric != null;
        });
    }

    boolean remove(String name) {
        return this.writeAccess(() -> {
            List<MetricID> doomedMetricsIDs = this.allMetricIDsByName.get(name);
            if (doomedMetricsIDs == null) {
                return false;
            }
            boolean result = false;
            for (MetricID metricID : doomedMetricsIDs) {
                HelidonMetric doomedMetric = this.allMetrics.get(metricID);
                if (doomedMetric == null) continue;
                doomedMetric.markAsDeleted();
                result |= this.allMetrics.remove(metricID) != null;
                this.doRemove.accept(SystemTagsManager.instance().metricIdWithAllTags(metricID, this.scope), doomedMetric);
            }
            this.allMetricIDsByName.remove(name);
            this.allMetadata.remove(name);
            this.tagNameSets.remove(name);
            this.metricTypes.remove(name);
            return result;
        });
    }

    void removeMatching(MetricFilter filter) {
        this.writeAccess(() -> {
            try {
                this.allMetrics.entrySet().stream().filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).forEach(this::removeLocked);
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Error removing using filter " + String.valueOf(filter), e);
            }
        });
    }

    SortedSet<String> getNames() {
        return new TreeSet<String>(this.allMetricIDsByName.keySet());
    }

    SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.allMetrics.keySet());
    }

    <V> SortedMap<MetricID, V> getSortedMetrics(MetricFilter filter, Class<V> metricClass) {
        Map<MetricID, Object> collected = this.allMetrics.entrySet().stream().filter(it -> metricClass.isAssignableFrom(((HelidonMetric)it.getValue()).getClass())).filter(it -> filter.matches((MetricID)it.getKey(), (Metric)it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> metricClass.cast(it.getValue())));
        return new TreeMap<MetricID, Object>(collected);
    }

    MetricsForMetadata metadataWithIDs(String metricName) {
        return this.readAccess(() -> {
            Metadata metadata = this.allMetadata.get(metricName);
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            return metadata == null || metricIDs == null || metricIDs.isEmpty() ? null : new MetricsForMetadata(metadata, metricIDs);
        });
    }

    HelidonMetric metric(MetricID metricID) {
        return this.allMetrics.get(metricID);
    }

    Map<String, Metadata> metadata() {
        return this.allMetadata;
    }

    Metadata metadata(String metricName) {
        return this.allMetadata.get(metricName);
    }

    Map<MetricID, HelidonMetric> metrics() {
        return this.allMetrics;
    }

    MetricInstance untaggedOrFirstMetricInstance(String metricName) {
        return this.readAccess(() -> {
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            if (metricIDs == null || metricIDs.isEmpty()) {
                return null;
            }
            MetricID metricID = null;
            for (MetricID candidate : metricIDs) {
                if (metricID != null && !candidate.getTags().isEmpty()) continue;
                metricID = candidate;
            }
            return new MetricInstance(metricID, this.allMetrics.get(metricID));
        });
    }

    List<MetricInstance> metricsWithIDs(String metricName) {
        return this.readAccess(() -> {
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            if (metricIDs == null) {
                return Collections.emptyList();
            }
            ArrayList<MetricInstance> result = new ArrayList<MetricInstance>();
            for (MetricID metricID : metricIDs) {
                result.add(new MetricInstance(metricID, this.allMetrics.get(metricID)));
            }
            return result;
        });
    }

    List<MetricID> metricIDs(String metricName) {
        return new ArrayList<MetricID>((Collection)this.allMetricIDsByName.get(metricName));
    }

    Stream<MetricInstance> stream() {
        return this.allMetrics.entrySet().stream().filter(entry -> this.registrySettings.isMetricEnabled(((MetricID)entry.getKey()).getName())).map(it -> new MetricInstance((MetricID)it.getKey(), (HelidonMetric)it.getValue()));
    }

    private void removeLocked(Map.Entry<MetricID, HelidonMetric> entry) {
        this.remove(entry.getKey());
    }

    private <U extends Metric> U getOrRegisterMetric(String metricName, Class<U> clazz, Supplier<HelidonMetric> metricFactory, Supplier<MetricID> metricIDFactory, Supplier<Metadata> metadataFactory, Tag ... tags) {
        Class<? extends Metric> newBaseType = MetricStore.baseMetricClass(clazz);
        return (U)this.writeAccess(() -> {
            this.enforceConsistentType(metricName, clazz);
            HelidonMetric metric = (HelidonMetric)metricFactory.get();
            MetricID newMetricID = (MetricID)metricIDFactory.get();
            this.checkOrStoreTagNames(newMetricID.getName(), newMetricID.getTags().keySet());
            if (metric == null) {
                Metadata metadata = (Metadata)metadataFactory.get();
                if (metadata == null) {
                    metadata = this.registerMetadataLocked(metricName);
                }
                metric = this.registerMetricLocked(newMetricID, this.createEnabledAwareMetric(clazz, metadata, tags));
            } else {
                this.ensureConsistentMetricTypes(metric, newBaseType, metricIDFactory);
                Metadata existingMetadata = (Metadata)metadataFactory.get();
                if (existingMetadata == null) {
                    throw new IllegalStateException("Could not find existing metadata under name " + metricName + " for existing metric " + String.valueOf(metricIDFactory.get()));
                }
            }
            return (Metric)clazz.cast(metric);
        });
    }

    private HelidonMetric getMetricLocked(String metricName, Tag ... tags) {
        List<MetricID> metricIDsForName = this.allMetricIDsByName.get(metricName);
        if (metricIDsForName == null) {
            return null;
        }
        for (MetricID metricID : metricIDsForName) {
            if (!metricID.getName().equals(metricName) || !MetricStore.tagsMatch(tags, metricID.getTags())) continue;
            return this.allMetrics.get(metricID);
        }
        return null;
    }

    private HelidonMetric registerMetricLocked(MetricID metricID, HelidonMetric metric) {
        this.allMetrics.put(metricID, metric);
        this.allMetricIDsByName.computeIfAbsent(metricID.getName(), k -> new ArrayList()).add(metricID);
        return metric;
    }

    private Metadata getConsistentMetadataLocked(String metricName) {
        Metadata result = this.allMetadata.get(metricName);
        if (result == null) {
            result = this.registerMetadataLocked(metricName);
        }
        return result;
    }

    private Metadata getConsistentMetadataLocked(Metadata newMetadata) {
        Metadata metadata = this.allMetadata.get(newMetadata.getName());
        if (metadata != null) {
            this.checkOrStoreMetadata(newMetadata);
        } else {
            this.registerMetadataLocked(newMetadata);
        }
        return newMetadata;
    }

    private Metadata registerMetadataLocked(String metricName) {
        return this.registerMetadataLocked(Metadata.builder().withName(metricName).withUnit("none").build());
    }

    private Metadata registerMetadataLocked(Metadata metadata) {
        this.checkOrStoreMetadata(metadata);
        this.allMetadata.put(metadata.getName(), metadata);
        return metadata;
    }

    private void ensureConsistentMetricTypes(HelidonMetric existingMetric, Class<? extends Metric> newBaseType, Supplier<MetricID> metricIDSupplier) {
        if (!MetricStore.baseMetricClass(existingMetric.getClass()).isAssignableFrom(newBaseType)) {
            MetricID tempID = metricIDSupplier.get();
            throw new IllegalArgumentException("Attempt to register new metric of type " + newBaseType.getName() + " when previously-registered metric " + tempID.getName() + String.valueOf(Arrays.asList(tempID.getTagsAsArray())) + " is of incompatible type " + String.valueOf(MetricStore.baseMetricClass(existingMetric.getClass())));
        }
    }

    private <U extends Metric> HelidonMetric createEnabledAwareMetric(Class<U> clazz, Metadata metadata, Tag ... tags) {
        Counter result;
        MetricFactory factoryToUse;
        String metricName = metadata.getName();
        Class<? extends Metric> baseClass = MetricStore.baseMetricClass(clazz);
        MetricFactory metricFactory = factoryToUse = this.registrySettings.isMetricEnabled(metricName) ? this.metricFactory : this.noOpMetricFactory;
        if (baseClass.isAssignableFrom(Counter.class)) {
            result = factoryToUse.counter(this.scope, metadata, tags);
        } else if (baseClass.isAssignableFrom(Histogram.class)) {
            result = factoryToUse.summary(this.scope, metadata, tags);
        } else if (baseClass.isAssignableFrom(Timer.class)) {
            result = factoryToUse.timer(this.scope, metadata, tags);
        } else {
            throw new IllegalArgumentException("Cannot identify correct metric type for " + clazz.getName());
        }
        return (HelidonMetric)result;
    }

    private <U extends Metric, T> HelidonMetric createEnabledAwareMetric(Class<U> clazz, Metadata metadata, T origin, ToDoubleFunction<T> function, Tag ... tags) {
        MetricFactory factoryToUse;
        String metricName = metadata.getName();
        Class<? extends Metric> baseClass = MetricStore.baseMetricClass(clazz);
        MetricFactory metricFactory = factoryToUse = this.registrySettings.isMetricEnabled(metricName) ? this.metricFactory : this.noOpMetricFactory;
        if (!baseClass.isAssignableFrom(Counter.class)) {
            throw new IllegalArgumentException("Cannot identify correct function metric type for " + clazz.getName());
        }
        Counter result = factoryToUse.counter(this.scope, metadata, origin, function, tags);
        return (HelidonMetric)result;
    }

    private <R extends Number> HelidonMetric createEnabledAwareGauge(Metadata metadata, Function<Metadata, Gauge<R>> gaugeFactory) {
        String metricName = metadata.getName();
        return (HelidonMetric)(this.registrySettings.isMetricEnabled(metricName) ? gaugeFactory.apply(metadata) : this.noOpMetricFactory.gauge(this.scope, metadata, null, new Tag[0]));
    }

    private <S> S readAccess(Callable<S> action) {
        return this.access(this.lock.readLock(), action);
    }

    private <S> S writeAccess(Callable<S> action) {
        return this.access(this.lock.writeLock(), action);
    }

    private <S> S access(Lock lock, Callable<S> action) {
        lock.lock();
        try {
            S s = action.call();
            return s;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private static boolean tagsMatch(Tag[] tags, Map<String, String> tagMap) {
        TreeMap<String, String> newTags = new TreeMap<String, String>();
        for (Tag tag : tags) {
            newTags.put(tag.getTagName(), tag.getTagValue());
        }
        return newTags.equals(tagMap);
    }
}

