/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsSettings;

class KeyPerformanceIndicatorMetricsSettingsImpl
implements KeyPerformanceIndicatorMetricsSettings {
    private final boolean isExtended;
    private final long longRunningRequestThresholdMs;

    KeyPerformanceIndicatorMetricsSettingsImpl(Builder builder) {
        this.isExtended = builder.isExtended();
        this.longRunningRequestThresholdMs = builder.longRunningRequestThresholdMs();
    }

    @Override
    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public long longRunningRequestThresholdMs() {
        return this.longRunningRequestThresholdMs;
    }

    static class Builder
    implements KeyPerformanceIndicatorMetricsSettings.Builder {
        private boolean isExtendedKpiEnabled = false;
        private long longRunningRequestThresholdMs = 10000L;
        public static final String KEY_PERFORMANCE_INDICATORS_CONFIG_KEY = "key-performance-indicators";
        public static final String KEY_PERFORMANCE_INDICATORS_EXTENDED_CONFIG_KEY = "extended";
        static final boolean KEY_PERFORMANCE_INDICATORS_EXTENDED_DEFAULT = false;
        public static final String LONG_RUNNING_REQUESTS_THRESHOLD_CONFIG_KEY = "threshold-ms";
        public static final String LONG_RUNNING_REQUESTS_CONFIG_KEY = "long-running-requests";
        static final long LONG_RUNNING_REQUESTS_THRESHOLD_MS_DEFAULT = 10000L;
        private static final String CONFIG_KEY_PREFIX = "metrics.key-performance-indicators";
        private static final String QUALIFIED_LONG_RUNNING_REQUESTS_THRESHOLD_CONFIG_KEY = "long-running-requests.extended";

        Builder() {
        }

        @Override
        @ConfiguredOption(key="extended")
        public KeyPerformanceIndicatorMetricsSettings.Builder extended(boolean value) {
            this.isExtendedKpiEnabled = value;
            return this;
        }

        @Override
        @ConfiguredOption(key="long-running-requests.threshold-ms", value="10000")
        public KeyPerformanceIndicatorMetricsSettings.Builder longRunningRequestThresholdMs(long value) {
            this.longRunningRequestThresholdMs = value;
            return this;
        }

        @Override
        public KeyPerformanceIndicatorMetricsSettings.Builder config(Config kpiConfig) {
            kpiConfig.get(KEY_PERFORMANCE_INDICATORS_EXTENDED_CONFIG_KEY).asBoolean().ifPresent(this::extended);
            kpiConfig.get(LONG_RUNNING_REQUESTS_CONFIG_KEY).get(LONG_RUNNING_REQUESTS_THRESHOLD_CONFIG_KEY).asLong().ifPresent(this::longRunningRequestThresholdMs);
            return this;
        }

        @Override
        public KeyPerformanceIndicatorMetricsSettings build() {
            return new KeyPerformanceIndicatorMetricsSettingsImpl(this);
        }

        @Override
        public boolean isExtended() {
            return this.isExtendedKpiEnabled;
        }

        @Override
        public long longRunningRequestThresholdMs() {
            return this.longRunningRequestThresholdMs;
        }
    }
}

