/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.FunctionalCounterRegistry;
import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.MetricInstance;
import io.helidon.metrics.api.MetricStore;
import io.helidon.metrics.api.MetricsForMetadata;
import io.helidon.metrics.api.Registry;
import io.helidon.metrics.api.RegistryFactory;
import io.helidon.metrics.api.RegistrySettings;
import io.helidon.metrics.api.spi.MetricFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public abstract class AbstractRegistry
implements Registry {
    private static final Tag[] NO_TAGS = new Tag[0];
    private final String scope;
    private final MetricStore metricStore;
    private final MetricFactory metricFactory;

    protected AbstractRegistry(String scope, RegistrySettings registrySettings, MetricFactory metricFactory) {
        this.scope = scope;
        this.metricStore = MetricStore.create(registrySettings, metricFactory, scope, this::doRemove);
        this.metricFactory = metricFactory;
    }

    public static boolean isMarkedAsDeleted(Metric metric) {
        return metric instanceof HelidonMetric && ((HelidonMetric)metric).isDeleted();
    }

    @Override
    public Optional<MetricInstance> find(String name) {
        return Optional.ofNullable(this.metricStore.untaggedOrFirstMetricInstance(name));
    }

    @Override
    public List<MetricInstance> list(String metricName) {
        return this.metricStore.metricsWithIDs(metricName);
    }

    @Override
    public List<MetricID> metricIdsByName(String name) {
        return this.metricStore.metricIDs(name);
    }

    @Override
    public Optional<MetricsForMetadata> metricsByName(String name) {
        return Optional.ofNullable(this.metricStore.metadataWithIDs(name));
    }

    public Counter counter(String name) {
        return this.counter(name, NO_TAGS);
    }

    public Counter counter(Metadata metadata) {
        return this.counter(metadata, NO_TAGS);
    }

    public Counter counter(String name, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(name, Counter.class, tags);
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(metadata, Counter.class, tags);
    }

    public Counter counter(MetricID metricID) {
        return this.metricStore.getOrRegisterMetric(metricID, Counter.class);
    }

    public Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, Counter.class);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, NO_TAGS);
    }

    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata, NO_TAGS);
    }

    public Histogram histogram(String name, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(name, Histogram.class, tags);
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(metadata, Histogram.class, tags);
    }

    public Histogram histogram(MetricID metricID) {
        return this.metricStore.getOrRegisterMetric(metricID, Histogram.class);
    }

    public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    public Timer timer(String name) {
        return this.timer(name, NO_TAGS);
    }

    public Timer timer(Metadata metadata) {
        return this.timer(metadata, NO_TAGS);
    }

    public Timer timer(String name, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(name, Timer.class, tags);
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.metricStore.getOrRegisterMetric(metadata, Timer.class, tags);
    }

    public Timer timer(MetricID metricID) {
        return this.metricStore.getOrRegisterMetric(metricID, Timer.class);
    }

    public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    public <T, R extends Number> Gauge<R> gauge(String name, T object, Function<T, R> func, Tag ... tags) {
        return this.metricStore.getOrRegisterGauge(name, object, func, tags);
    }

    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T object, Function<T, R> func) {
        return this.metricStore.getOrRegisterGauge(metricID, object, func);
    }

    public <T, R extends Number> Gauge<R> gauge(Metadata metadata, T object, Function<T, R> func, Tag ... tags) {
        return this.metricStore.getOrRegisterGauge(metadata, object, func, tags);
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> supplier, Tag ... tags) {
        return this.metricStore.getOrRegisterGauge(name, supplier, tags);
    }

    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> supplier) {
        return this.metricStore.getOrRegisterGauge(metricID, supplier);
    }

    public <T extends Number> Gauge<T> gauge(Metadata metadata, Supplier<T> supplier, Tag ... tags) {
        return this.metricStore.getOrRegisterGauge(metadata, supplier, tags);
    }

    public Gauge<?> getGauge(MetricID metricID) {
        return this.getMetric(metricID, Gauge.class);
    }

    public boolean remove(String name) {
        return this.metricStore.remove(name);
    }

    public boolean remove(MetricID metricID) {
        return this.metricStore.remove(metricID);
    }

    public void removeMatching(MetricFilter filter) {
        this.metricStore.removeMatching(filter);
    }

    public SortedSet<String> getNames() {
        return this.metricStore.getNames();
    }

    public SortedSet<MetricID> getMetricIDs() {
        return this.metricStore.getMetricIDs();
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Gauge.class);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Counter.class);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Histogram.class);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Timer.class);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metricStore.metadata());
    }

    public Metadata getMetadata(String name) {
        return this.metricStore.metadata(name);
    }

    public Map<MetricID, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricStore.metrics());
    }

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, Metric.class);
    }

    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        return this.metricStore.getSortedMetrics(filter, ofType);
    }

    @Override
    public HelidonMetric getMetric(MetricID metricID) {
        return this.metricStore.metric(metricID);
    }

    public <T extends Metric> T getMetric(MetricID metricID, Class<T> asType) {
        return (T)((Metric)asType.cast(this.metricStore.metric(metricID)));
    }

    public void update(RegistrySettings registrySettings) {
        this.metricStore.update(registrySettings);
    }

    @Override
    public String scope() {
        return this.scope;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean empty() {
        return this.metricStore.metrics().isEmpty();
    }

    public String toString() {
        return this.scope() + ": " + this.metricStore.metrics().size() + " metrics";
    }

    @Override
    public Stream<MetricInstance> stream() {
        return this.metricStore.stream();
    }

    protected List<MetricID> metricIDsForName(String metricName) {
        return this.metricStore.metricIDs(metricName);
    }

    protected <T, R extends Number> Gauge<R> createGauge(Metadata metadata, T object, Function<T, R> func) {
        return this.createGauge(metadata, () -> (Number)func.apply(object));
    }

    protected FunctionalCounterRegistry metricStore() {
        return this.metricStore;
    }

    protected abstract <R extends Number> Gauge<R> createGauge(Metadata var1, Supplier<R> var2);

    protected abstract void doRemove(MetricID var1, HelidonMetric var2);

    protected static Class<? extends Metric> deriveType(Metric metric) {
        return RegistryFactory.METRIC_TYPES.stream().filter(clazz -> clazz.isInstance(metric)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot map metric of type " + metric.getClass().getName() + " to one of " + String.valueOf(RegistryFactory.METRIC_TYPES)));
    }

    protected MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public static interface GaugeFactory {

        @FunctionalInterface
        public static interface FunctionBased {
            public <T, R extends Number> Gauge<R> createGauge(Metadata var1, T var2, Function<T, R> var3);
        }

        @FunctionalInterface
        public static interface SupplierBased {
            public <R extends Number> Gauge<R> createGauge(Metadata var1, Supplier<R> var2);
        }
    }
}

