/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.AbstractRegistry;
import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.MetricInstance;
import io.helidon.metrics.api.MetricsForMetadata;
import io.helidon.metrics.api.NoOpMetricImpl;
import io.helidon.metrics.api.RegistrySettings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

class NoOpMetricRegistry
extends AbstractRegistry {
    static final Map<MetricType, BiFunction<String, Metadata, HelidonMetric>> NO_OP_METRIC_FACTORIES = Map.of(MetricType.COUNTER, NoOpMetricImpl.NoOpCounterImpl::create, MetricType.GAUGE, NoOpMetricImpl.NoOpGaugeImpl::create, MetricType.HISTOGRAM, NoOpMetricImpl.NoOpHistogramImpl::create, MetricType.METERED, NoOpMetricImpl.NoOpMeterImpl::create, MetricType.TIMER, NoOpMetricImpl.NoOpTimerImpl::create, MetricType.SIMPLE_TIMER, NoOpMetricImpl.NoOpSimpleTimerImpl::create, MetricType.CONCURRENT_GAUGE, NoOpMetricImpl.NoOpConcurrentGaugeImpl::create);
    private static final RegistrySettings REGISTRY_SETTINGS = RegistrySettings.builder().enabled(false).build();

    private NoOpMetricRegistry(MetricRegistry.Type type) {
        super(type, REGISTRY_SETTINGS);
    }

    public static NoOpMetricRegistry create(MetricRegistry.Type type) {
        return new NoOpMetricRegistry(type);
    }

    @Override
    public boolean enabled(String metricName) {
        return false;
    }

    @Override
    public Optional<MetricInstance> find(String metricName) {
        return Optional.empty();
    }

    @Override
    public List<MetricInstance> list(String metricName) {
        return List.of();
    }

    @Override
    public List<MetricID> metricIdsByName(String name) {
        return List.of();
    }

    @Override
    public Optional<MetricsForMetadata> metricsByName(String name) {
        return Optional.empty();
    }

    @Override
    protected HelidonMetric toImpl(Metadata metadata, Metric metric) {
        String registryTypeName = this.type();
        MetricType metricType = AbstractRegistry.deriveType(metadata.getTypeRaw(), metric);
        return switch (metricType) {
            default -> throw new IncompatibleClassChangeError();
            case MetricType.COUNTER -> NoOpMetricImpl.NoOpCounterImpl.create(registryTypeName, metadata);
            case MetricType.GAUGE -> NoOpMetricImpl.NoOpGaugeImpl.create(registryTypeName, metadata, (Gauge)metric);
            case MetricType.HISTOGRAM -> NoOpMetricImpl.NoOpHistogramImpl.create(registryTypeName, metadata);
            case MetricType.METERED -> NoOpMetricImpl.NoOpMeterImpl.create(registryTypeName, metadata);
            case MetricType.TIMER -> NoOpMetricImpl.NoOpTimerImpl.create(registryTypeName, metadata);
            case MetricType.SIMPLE_TIMER -> NoOpMetricImpl.NoOpSimpleTimerImpl.create(registryTypeName, metadata);
            case MetricType.CONCURRENT_GAUGE -> NoOpMetricImpl.NoOpConcurrentGaugeImpl.create(registryTypeName, metadata);
            case MetricType.INVALID -> throw new IllegalArgumentException("Unexpected metric type " + String.valueOf(metricType) + ": " + metric.getClass().getName());
        };
    }

    @Override
    protected Map<MetricType, BiFunction<String, Metadata, HelidonMetric>> prepareMetricFactories() {
        return NoOpMetricRegistry.noOpMetricFactories();
    }

    @Override
    protected <T, R extends Number> Gauge<R> createGauge(Metadata metadata, T object, Function<T, R> func) {
        return NoOpMetricImpl.NoOpGaugeImpl.create(this.type(), metadata, () -> (Number)func.apply(object));
    }

    @Override
    protected <R extends Number> Gauge<R> createGauge(Metadata metadata, Supplier<R> supplier) {
        return NoOpMetricImpl.NoOpGaugeImpl.create(this.type(), metadata, () -> (Number)supplier.get());
    }

    @Override
    protected Map<Class<? extends HelidonMetric>, MetricType> prepareMetricToTypeMap() {
        return Map.of(NoOpMetricImpl.NoOpConcurrentGaugeImpl.class, MetricType.CONCURRENT_GAUGE, NoOpMetricImpl.NoOpCounterImpl.class, MetricType.COUNTER, NoOpMetricImpl.NoOpGaugeImpl.class, MetricType.GAUGE, NoOpMetricImpl.NoOpHistogramImpl.class, MetricType.HISTOGRAM, NoOpMetricImpl.NoOpMeterImpl.class, MetricType.METERED, NoOpMetricImpl.NoOpTimerImpl.class, MetricType.TIMER, NoOpMetricImpl.NoOpSimpleTimerImpl.class, MetricType.SIMPLE_TIMER);
    }

    protected static Map<MetricType, BiFunction<String, Metadata, HelidonMetric>> noOpMetricFactories() {
        return NO_OP_METRIC_FACTORIES;
    }
}

