/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.metrics.api.spi.ExemplarService;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.function.Supplier;

class ExemplarServiceManager {
    private static final System.Logger LOGGER = System.getLogger(ExemplarServiceManager.class.getName());
    private static final List<ExemplarService> EXEMPLAR_SERVICES = ExemplarServiceManager.collectExemplarServices();
    private static final boolean IS_ACTIVE = !EXEMPLAR_SERVICES.isEmpty();
    static final String INACTIVE_LABEL = "";
    private static final Supplier<String> EXEMPLAR_SUPPLIER = () -> EXEMPLAR_SERVICES.stream().map(ExemplarService::label).filter(Predicate.not(String::isBlank)).collect(ExemplarServiceManager::labelsStringJoiner, StringJoiner::add, StringJoiner::merge).toString();

    private ExemplarServiceManager() {
    }

    private static StringJoiner labelsStringJoiner() {
        return new StringJoiner(",", "{", "}").setEmptyValue(INACTIVE_LABEL);
    }

    static String exemplarLabel() {
        return IS_ACTIVE ? EXEMPLAR_SUPPLIER.get() : INACTIVE_LABEL;
    }

    static boolean isActive() {
        return IS_ACTIVE;
    }

    private static List<ExemplarService> collectExemplarServices() {
        List exemplarServices = HelidonServiceLoader.create(ServiceLoader.load(ExemplarService.class)).asList();
        if (!exemplarServices.isEmpty()) {
            LOGGER.log(System.Logger.Level.INFO, "Using metrics ExemplarServices " + exemplarServices.toString());
        }
        return exemplarServices;
    }
}

