/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.api.SystemTagsManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.eclipse.microprofile.metrics.MetricID;

class SystemTagsManagerImpl
implements SystemTagsManager {
    private static final String APP_TAG_NAME = "_app";
    private static SystemTagsManagerImpl instance = new SystemTagsManagerImpl();
    private final Map<String, String> systemTags;

    public static SystemTagsManager instance() {
        return instance;
    }

    static SystemTagsManagerImpl create(MetricsSettings metricsSettings) {
        instance = new SystemTagsManagerImpl(metricsSettings);
        return instance;
    }

    private SystemTagsManagerImpl(MetricsSettings metricsSettings) {
        HashMap<String, String> result = new HashMap<String, String>(metricsSettings.globalTags());
        if (metricsSettings.appTagValue() != null) {
            result.put(APP_TAG_NAME, metricsSettings.appTagValue());
        }
        this.systemTags = Collections.unmodifiableMap(result);
    }

    private SystemTagsManagerImpl() {
        this.systemTags = Collections.emptyMap();
    }

    @Override
    public Iterable<Map.Entry<String, String>> allTags(Map<String, String> explicitTags) {
        return new MultiIterable<Map.Entry<String, String>>(explicitTags.entrySet(), this.systemTags.entrySet());
    }

    @Override
    public Iterable<Map.Entry<String, String>> allTags(MetricID metricID) {
        return new MultiIterable<Map.Entry<String, String>>(metricID.getTags().entrySet(), this.systemTags.entrySet());
    }

    static class MultiIterable<T>
    implements Iterable<T> {
        private final Iterable<T>[] iterables;
        private final Iterator<T> emptyIterator = new Iterator<T>(this){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }
        };

        private MultiIterable(Iterable<T> ... iterables) {
            if (iterables.length == 0) {
                throw new IllegalArgumentException("Must provide at least one Iterable");
            }
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int nextIndex = 0;
                private Iterator<T> current = this.nextIterator();

                @Override
                public boolean hasNext() {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    this.current = this.nextIterator();
                    return this.current.hasNext();
                }

                @Override
                public T next() {
                    return this.current.next();
                }

                private Iterator<T> nextIterator() {
                    while (this.nextIndex < iterables.length) {
                        Iterator candidateNextIterator = iterables[this.nextIndex].iterator();
                        if (candidateNextIterator.hasNext()) {
                            ++this.nextIndex;
                            return candidateNextIterator;
                        }
                        ++this.nextIndex;
                    }
                    return emptyIterator;
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (Iterable<? super T> iterable : this.iterables) {
                iterable.forEach(action);
            }
        }
    }
}

