/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.metrics.api.BaseMetricsSettings;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsSettings;
import io.helidon.metrics.api.MetricsSettingsImpl;
import io.helidon.metrics.api.RegistrySettings;
import java.util.Map;
import org.eclipse.microprofile.metrics.MetricRegistry;

public interface MetricsSettings {
    public static MetricsSettings create() {
        return MetricsSettings.create(Config.create().get("metrics"));
    }

    public static MetricsSettings create(Config config) {
        return MetricsSettings.builder().config(config).build();
    }

    public static Builder builder() {
        return new MetricsSettingsImpl.Builder();
    }

    public static Builder builder(MetricsSettings metricsSettings) {
        return new MetricsSettingsImpl.Builder(metricsSettings);
    }

    public boolean isEnabled();

    public KeyPerformanceIndicatorMetricsSettings keyPerformanceIndicatorSettings();

    public BaseMetricsSettings baseMetricsSettings();

    public boolean isMetricEnabled(MetricRegistry.Type var1, String var2);

    public RegistrySettings registrySettings(MetricRegistry.Type var1);

    public Map<String, String> globalTags();

    public String appTagValue();

    @Configured(prefix="metrics")
    public static interface Builder
    extends io.helidon.common.Builder<Builder, MetricsSettings> {
        public static final String ENABLED_CONFIG_KEY = "enabled";
        public static final String METRICS_CONFIG_KEY = "metrics";
        public static final String BASE_CONFIG_KEY = "base";
        public static final String REGISTRIES_CONFIG_KEY = "registries";
        public static final String DEFAULT_CONTEXT = "/metrics";
        public static final String EXEMPLARS_STRICT_CONFIG_KEY = "exemplars.strict";
        public static final String GLOBAL_TAGS_CONFIG_KEY = "tags";
        public static final String APP_TAG_CONFIG_KEY = "appName";

        public MetricsSettings build();

        public Builder enabled(boolean var1);

        public Builder config(Config var1);

        public Builder keyPerformanceIndicatorSettings(KeyPerformanceIndicatorMetricsSettings.Builder var1);

        public Builder baseMetricsSettings(BaseMetricsSettings.Builder var1);

        public Builder registrySettings(MetricRegistry.Type var1, RegistrySettings var2);

        public Builder globalTags(Map<String, String> var1);

        public Builder appTagValue(String var1);
    }
}

