/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.AbstractRegistry;
import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.NoOpMetric;
import io.helidon.metrics.api.NoOpMetricRegistry;
import io.helidon.metrics.api.RegistrySettings;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

class MetricStore<M extends HelidonMetric> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Map<MetricID, M> allMetrics = new ConcurrentHashMap<MetricID, M>();
    private final Map<String, List<MetricID>> allMetricIDsByName = new ConcurrentHashMap<String, List<MetricID>>();
    private final Map<String, Metadata> allMetadata = new ConcurrentHashMap<String, Metadata>();
    private volatile RegistrySettings registrySettings;
    private final Map<MetricType, BiFunction<String, Metadata, M>> metricFactories;
    private final AbstractRegistry.GaugeFactory.SupplierBased supplierBasedGaugeFactory;
    private final AbstractRegistry.GaugeFactory.FunctionBased functionBasedGaugeFactory;
    private final MetricRegistry.Type registryType;
    private final Class<M> metricClass;
    private final BiFunction<Metadata, Metric, M> toImpl;

    static <M extends HelidonMetric> MetricStore<M> create(RegistrySettings registrySettings, Map<MetricType, BiFunction<String, Metadata, M>> metricFactories, AbstractRegistry.GaugeFactory.SupplierBased supplierBasedGaugeFactory, AbstractRegistry.GaugeFactory.FunctionBased functionBasedGaugeFactory, MetricRegistry.Type registryType, Class<M> metricClass, BiFunction<Metadata, Metric, M> toImpl) {
        return new MetricStore<M>(registrySettings, metricFactories, supplierBasedGaugeFactory, functionBasedGaugeFactory, registryType, metricClass, toImpl);
    }

    private MetricStore(RegistrySettings registrySettings, Map<MetricType, BiFunction<String, Metadata, M>> metricFactories, AbstractRegistry.GaugeFactory.SupplierBased supplierBasedGaugeFactory, AbstractRegistry.GaugeFactory.FunctionBased functionBasedGaugeFactory, MetricRegistry.Type registryType, Class<M> metricClass, BiFunction<Metadata, Metric, M> toImpl) {
        this.registrySettings = registrySettings;
        this.metricFactories = metricFactories;
        this.supplierBasedGaugeFactory = supplierBasedGaugeFactory;
        this.functionBasedGaugeFactory = functionBasedGaugeFactory;
        this.registryType = registryType;
        this.metricClass = metricClass;
        this.toImpl = toImpl;
    }

    void update(RegistrySettings registrySettings) {
        this.registrySettings = registrySettings;
    }

    <U extends Metric> U getOrRegisterMetric(MetricID metricID, Class<U> clazz) {
        return this.getOrRegisterMetric(metricID.getName(), clazz, () -> (HelidonMetric)this.allMetrics.get(metricID), () -> metricID, () -> this.getConsistentMetadataLocked(metricID.getName(), MetricType.from((Class)clazz)));
    }

    <U extends Metric> U getOrRegisterMetric(String metricName, Class<U> clazz, Tag ... tags) {
        return this.getOrRegisterMetric(metricName, clazz, () -> this.getMetricLocked(metricName, tags), () -> new MetricID(metricName, tags), () -> this.getConsistentMetadataLocked(metricName, MetricType.from((Class)clazz)));
    }

    <U extends Metric> U getOrRegisterMetric(Metadata newMetadata, Class<U> clazz, Tag ... tags) {
        return (U)this.writeAccess(() -> {
            M metric = this.getMetricLocked(newMetadata.getName(), tags);
            if (metric == null) {
                Metadata metadataToUse = newMetadata.getTypeRaw().equals((Object)MetricType.INVALID) ? Metadata.builder((Metadata)newMetadata).withType(MetricType.from((Class)clazz)).build() : newMetadata;
                Metadata metadata = this.getConsistentMetadataLocked(metadataToUse);
                metric = this.registerMetricLocked(new MetricID(metadata.getName(), tags), this.createEnabledAwareMetric(clazz, metadata));
            } else {
                MetricStore.enforceConsistentMetadata(metric.metadata(), newMetadata);
            }
            return this.toType(metric, clazz);
        });
    }

    <T, R extends Number> Gauge<R> getOrRegisterGauge(String name, T object, Function<T, R> func, Tag ... tags) {
        return this.getOrRegisterGauge(() -> this.getMetricLocked(name, tags), () -> this.getConsistentMetadataLocked(name, MetricType.GAUGE), () -> new MetricID(name, tags), (Metadata metadata) -> this.functionBasedGaugeFactory.createGauge((Metadata)metadata, object, func));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(String name, Supplier<R> valueSupplier, Tag ... tags) {
        return this.getOrRegisterGauge(() -> this.getMetricLocked(name, tags), () -> this.getConsistentMetadataLocked(name, MetricType.GAUGE), () -> new MetricID(name, tags), (Metadata metadata) -> this.supplierBasedGaugeFactory.createGauge((Metadata)metadata, valueSupplier));
    }

    <T, R extends Number> Gauge<R> getOrRegisterGauge(Metadata newMetadata, T object, Function<T, R> valueFunction, Tag ... tags) {
        return this.getOrRegisterGauge(() -> this.getMetricLocked(newMetadata.getName(), tags), () -> this.getConsistentMetadataLocked(newMetadata), () -> new MetricID(newMetadata.getName(), tags), (Metadata metadata) -> this.functionBasedGaugeFactory.createGauge((Metadata)metadata, object, valueFunction));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(Metadata newMetadata, Supplier<R> valueSupplier, Tag ... tags) {
        String metricName = newMetadata.getName();
        return this.getOrRegisterGauge(() -> this.getMetricLocked(metricName, tags), () -> this.getConsistentMetadataLocked(newMetadata), () -> new MetricID(metricName, tags), (Metadata metadata) -> this.supplierBasedGaugeFactory.createGauge((Metadata)metadata, valueSupplier));
    }

    <T, R extends Number> Gauge<R> getOrRegisterGauge(MetricID metricID, T object, Function<T, R> valueFunction) {
        return this.getOrRegisterGauge(() -> (HelidonMetric)this.allMetrics.get(metricID), () -> this.allMetadata.get(metricID.getName()), () -> metricID, (Metadata metadata) -> this.functionBasedGaugeFactory.createGauge((Metadata)metadata, object, valueFunction));
    }

    <R extends Number> Gauge<R> getOrRegisterGauge(MetricID metricID, Supplier<R> valueSupplier) {
        return this.getOrRegisterGauge(() -> (HelidonMetric)this.allMetrics.get(metricID), () -> this.allMetadata.get(metricID.getName()), () -> metricID, (Metadata metadata) -> this.supplierBasedGaugeFactory.createGauge((Metadata)metadata, valueSupplier));
    }

    private <R extends Number> Gauge<R> getOrRegisterGauge(Supplier<M> metricFinder, Supplier<Metadata> metadataFinder, Supplier<MetricID> metricIDSupplier, Function<Metadata, Gauge<R>> gaugeFactory) {
        return this.writeAccess(() -> {
            HelidonMetric metric = (HelidonMetric)metricFinder.get();
            if (metric == null) {
                Metadata metadata = (Metadata)metadataFinder.get();
                metric = this.registerMetricLocked((MetricID)metricIDSupplier.get(), this.createEnabledAwareGauge(metadata, gaugeFactory));
            }
            return (Gauge)metric;
        });
    }

    <U extends Metric> U register(Metadata metadata, U metric, Tag ... tags) {
        return (U)this.writeAccess(() -> {
            String metricName = metadata.getName();
            this.getConsistentMetadataLocked(metadata);
            this.registerMetricLocked(new MetricID(metricName, tags), (HelidonMetric)this.toImpl.apply(metadata, metric));
            return metric;
        });
    }

    <U extends Metric> U register(String name, U metric) {
        return (U)this.writeAccess(() -> {
            Metadata metadata = this.getConsistentMetadataLocked(name, this.toType(metric));
            this.registerMetricLocked(new MetricID(name), (HelidonMetric)this.toImpl.apply(metadata, metric));
            return metric;
        });
    }

    boolean remove(MetricID metricID) {
        return this.writeAccess(() -> {
            HelidonMetric doomedMetric;
            List<MetricID> metricIDsForName = this.allMetricIDsByName.get(metricID.getName());
            if (metricIDsForName == null) {
                return false;
            }
            metricIDsForName.remove(metricID);
            if (metricIDsForName.isEmpty()) {
                this.allMetricIDsByName.remove(metricID.getName());
                this.allMetadata.remove(metricID.getName());
            }
            if ((doomedMetric = (HelidonMetric)this.allMetrics.remove(metricID)) != null) {
                doomedMetric.markAsDeleted();
            }
            return doomedMetric != null;
        });
    }

    boolean remove(String name) {
        return this.writeAccess(() -> {
            List<MetricID> doomedMetricsIDs = this.allMetricIDsByName.get(name);
            if (doomedMetricsIDs == null) {
                return false;
            }
            boolean result = false;
            for (MetricID metricID : doomedMetricsIDs) {
                HelidonMetric metric = (HelidonMetric)this.allMetrics.get(metricID);
                if (metric == null) continue;
                metric.markAsDeleted();
                result |= this.allMetrics.remove(metricID) != null;
            }
            this.allMetricIDsByName.remove(name);
            this.allMetadata.remove(name);
            return result;
        });
    }

    void removeMatching(MetricFilter filter) {
        this.writeAccess(() -> {
            try {
                this.allMetrics.entrySet().stream().filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).forEach(this::removeLocked);
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Error removing using filter " + filter, e);
            }
        });
    }

    SortedSet<String> getNames() {
        return new TreeSet<String>(this.allMetricIDsByName.keySet());
    }

    SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.allMetrics.keySet());
    }

    <V> SortedMap<MetricID, V> getSortedMetrics(MetricFilter filter, Class<V> metricClass) {
        Map<MetricID, Object> collected = this.allMetrics.entrySet().stream().filter(it -> metricClass.isAssignableFrom(((HelidonMetric)it.getValue()).getClass())).filter(it -> filter.matches((MetricID)it.getKey(), (Metric)it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> metricClass.cast(it.getValue())));
        return new TreeMap<MetricID, Object>(collected);
    }

    Map.Entry<Metadata, List<MetricID>> metadataWithIDs(String metricName) {
        return this.readAccess(() -> {
            Metadata metadata = this.allMetadata.get(metricName);
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            return metadata == null || metricIDs == null || metricIDs.isEmpty() ? null : new AbstractMap.SimpleEntry<Metadata, List<MetricID>>(metadata, metricIDs);
        });
    }

    M metric(MetricID metricID) {
        return (M)((HelidonMetric)this.allMetrics.get(metricID));
    }

    Map<String, Metadata> metadata() {
        return this.allMetadata;
    }

    Metadata metadata(String metricName) {
        return this.allMetadata.get(metricName);
    }

    Map<MetricID, M> metrics() {
        return this.allMetrics;
    }

    Map.Entry<MetricID, M> untaggedOrFirstMetricWithID(String metricName) {
        return this.readAccess(() -> {
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            if (metricIDs == null || metricIDs.isEmpty()) {
                return null;
            }
            MetricID metricID = null;
            for (MetricID candidate : metricIDs) {
                if (metricID != null && !candidate.getTags().isEmpty()) continue;
                metricID = candidate;
            }
            return new AbstractMap.SimpleImmutableEntry<MetricID, HelidonMetric>(metricID, (HelidonMetric)this.allMetrics.get(metricID));
        });
    }

    List<Map.Entry<MetricID, M>> metricsWithIDs(String metricName) {
        return this.readAccess(() -> {
            List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
            if (metricIDs == null) {
                return Collections.emptyList();
            }
            ArrayList<AbstractMap.SimpleImmutableEntry<MetricID, HelidonMetric>> result = new ArrayList<AbstractMap.SimpleImmutableEntry<MetricID, HelidonMetric>>();
            for (MetricID metricID : metricIDs) {
                result.add(new AbstractMap.SimpleImmutableEntry<MetricID, HelidonMetric>(metricID, (HelidonMetric)this.allMetrics.get(metricID)));
            }
            return result;
        });
    }

    List<MetricID> metricIDs(String metricName) {
        return new ArrayList<MetricID>((Collection)this.allMetricIDsByName.get(metricName));
    }

    Stream<Map.Entry<MetricID, M>> stream() {
        return this.allMetrics.entrySet().stream().filter(entry -> this.registrySettings.isMetricEnabled(((MetricID)entry.getKey()).getName()));
    }

    private void removeLocked(Map.Entry<MetricID, M> entry) {
        this.remove(entry.getKey());
    }

    private <U extends Metric> U getOrRegisterMetric(String metricName, Class<U> clazz, Supplier<M> metricFactory, Supplier<MetricID> metricIDFactory, Supplier<Metadata> metadataFactory) {
        return (U)this.writeAccess(() -> {
            HelidonMetric metric = (HelidonMetric)metricFactory.get();
            if (metric == null) {
                try {
                    MetricType metricType = MetricType.from((Class)clazz);
                    Metadata metadata = (Metadata)metadataFactory.get();
                    if (metadata == null) {
                        metadata = this.registerMetadataLocked(metricName, metricType);
                    }
                    metric = this.registerMetricLocked((MetricID)metricIDFactory.get(), this.createEnabledAwareMetric(clazz, metadata));
                }
                catch (Exception e) {
                    throw new RuntimeException("Error attempting to register new metric " + metricIDFactory.get(), e);
                }
            }
            return this.toType(metric, clazz);
        });
    }

    private M getMetricLocked(String metricName, Tag ... tags) {
        List<MetricID> metricIDsForName = this.allMetricIDsByName.get(metricName);
        if (metricIDsForName == null) {
            return null;
        }
        for (MetricID metricID : metricIDsForName) {
            if (!metricID.getName().equals(metricName) || !Arrays.equals(metricID.getTagsAsArray(), tags)) continue;
            return (M)((HelidonMetric)this.allMetrics.get(metricID));
        }
        return null;
    }

    private <T extends M> T registerMetricLocked(MetricID metricID, T metric) {
        this.allMetrics.put(metricID, metric);
        this.allMetricIDsByName.computeIfAbsent(metricID.getName(), k -> new ArrayList()).add(metricID);
        return metric;
    }

    private Metadata getConsistentMetadataLocked(String metricName, MetricType metricType) {
        Metadata result = this.allMetadata.get(metricName);
        if (result != null) {
            if (result.getTypeRaw() != metricType) {
                throw new IllegalArgumentException("Existing metadata has type " + result.getType() + " but " + metricType + " was requested");
            }
        } else {
            result = this.registerMetadataLocked(metricName, metricType);
        }
        return result;
    }

    private Metadata getConsistentMetadataLocked(Metadata newMetadata) {
        Metadata metadata = this.allMetadata.get(newMetadata.getName());
        if (metadata != null) {
            MetricStore.enforceConsistentMetadata(metadata, newMetadata);
        } else {
            this.registerMetadataLocked(newMetadata);
        }
        return newMetadata;
    }

    private Metadata registerMetadataLocked(String metricName, MetricType metricType) {
        return this.registerMetadataLocked(Metadata.builder().withName(metricName).withType(metricType).withUnit("none").build());
    }

    private Metadata registerMetadataLocked(Metadata metadata) {
        this.allMetadata.put(metadata.getName(), metadata);
        return metadata;
    }

    private <U extends Metric> M createEnabledAwareMetric(Class<U> clazz, Metadata metadata) {
        String metricName = metadata.getName();
        MetricType metricType = MetricType.from(clazz);
        return (M)(this.registrySettings.isMetricEnabled(metricName) ? (HelidonMetric)this.metricFactories.get(MetricType.from(clazz)).apply(this.registryType.getName(), metadata) : (HelidonMetric)this.metricClass.cast(Proxy.newProxyInstance(this.metricClass.getClassLoader(), new Class[]{clazz, this.metricClass}, (InvocationHandler)new DisabledMetricInvocationHandler(metricType, metricName, metadata))));
    }

    private <R extends Number> M createEnabledAwareGauge(Metadata metadata, Function<Metadata, Gauge<R>> gaugeFactory) {
        String metricName = metadata.getName();
        return (M)((HelidonMetric)this.metricClass.cast(this.registrySettings.isMetricEnabled(metricName) ? gaugeFactory.apply(metadata) : Proxy.newProxyInstance(this.metricClass.getClassLoader(), new Class[]{Gauge.class, this.metricClass}, (InvocationHandler)new DisabledMetricInvocationHandler(MetricType.GAUGE, metricName, metadata))));
    }

    private <T extends M, U extends Metric> U toType(T m1, Class<U> clazz) {
        MetricType type2;
        MetricType type1 = this.toType((Metric)m1);
        if (type1 == (type2 = MetricType.from(clazz))) {
            return (U)((Metric)clazz.cast(m1));
        }
        throw new IllegalArgumentException("Metric types " + type1.toString() + " and " + type2.toString() + " do not match");
    }

    private MetricType toType(Metric metric) {
        Class<Metric> clazz = MetricStore.toMetricClass(metric);
        return MetricType.from(clazz == null ? metric.getClass() : clazz);
    }

    private static <T extends Metric> Class<? extends Metric> toMetricClass(T metric) {
        Class clazz = metric.getClass();
        do {
            Optional<Class> optionalClass;
            if (!(optionalClass = Arrays.stream(clazz.getInterfaces()).filter(Metric.class::isAssignableFrom).findFirst()).isPresent()) continue;
            clazz = optionalClass.get();
            break;
        } while ((clazz = clazz.getSuperclass()) != null);
        return clazz;
    }

    private <S> S readAccess(Callable<S> action) {
        return this.access(this.lock.readLock(), action);
    }

    private <S> S writeAccess(Callable<S> action) {
        return this.access(this.lock.writeLock(), action);
    }

    private <S> S access(Lock lock, Callable<S> action) {
        lock.lock();
        try {
            S s = action.call();
            return s;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private static void enforceConsistentMetadata(Metadata existingMetadata, Metadata newMetadata) {
        if (!MetricStore.metadataMatches(existingMetadata, newMetadata)) {
            throw new IllegalArgumentException("New metadata conflicts with existing metadata with the same name; existing: " + existingMetadata + ", new: " + newMetadata);
        }
    }

    static <T extends Metadata, U extends Metadata> boolean metadataMatches(T a, U b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getName().equals(b.getName()) && a.getTypeRaw().equals((Object)b.getTypeRaw()) && a.getDisplayName().equals(b.getDisplayName()) && Objects.equals(a.getDescription(), b.getDescription()) && Objects.equals(a.getUnit(), b.getUnit());
    }

    private static class DisabledMetricInvocationHandler
    implements InvocationHandler {
        private final NoOpMetric delegate;

        DisabledMetricInvocationHandler(MetricType metricType, String metricName, Metadata metadata) {
            this.delegate = NoOpMetricRegistry.noOpMetricFactories().get(metricType).apply(metricName, metadata);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.delegate, args);
        }
    }
}

