/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.NoOpMetric;
import io.helidon.metrics.api.NoOpMetricRegistry;
import io.helidon.metrics.api.RegistrySettings;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public abstract class AbstractRegistry<M extends HelidonMetric>
extends MetricRegistry {
    private static final Logger LOGGER = Logger.getLogger(AbstractRegistry.class.getName());
    private static final Tag[] NO_TAGS = new Tag[0];
    private final MetricRegistry.Type type;
    private final Map<MetricID, M> allMetrics = new ConcurrentHashMap<MetricID, M>();
    private final Map<String, List<MetricID>> allMetricIDsByName = new ConcurrentHashMap<String, List<MetricID>>();
    private final Map<String, Metadata> allMetadata = new ConcurrentHashMap<String, Metadata>();
    private final Map<MetricType, BiFunction<String, Metadata, M>> metricFactories = this.prepareMetricFactories();
    private final Class<M> metricClass;
    private final RegistrySettings registrySettings;

    protected AbstractRegistry(MetricRegistry.Type type, Class<M> metricClass, RegistrySettings registrySettings) {
        this.type = type;
        this.metricClass = metricClass;
        this.registrySettings = registrySettings;
    }

    public static boolean isMarkedAsDeleted(Metric metric) {
        return metric instanceof HelidonMetric && ((HelidonMetric)metric).isDeleted();
    }

    protected abstract boolean isMetricEnabled(String var1);

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.registerUniqueMetric(name, metric);
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(metadata, metric, NO_TAGS);
    }

    public <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        return this.registerUniqueMetric(metadata, metric, tags);
    }

    public Counter counter(String name) {
        return this.counter(name, NO_TAGS);
    }

    public Counter counter(Metadata metadata) {
        return this.counter(metadata, NO_TAGS);
    }

    public Counter counter(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, Counter.class, tags);
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, Counter.class, tags);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, NO_TAGS);
    }

    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata, NO_TAGS);
    }

    public Histogram histogram(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, Histogram.class, tags);
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, Histogram.class, tags);
    }

    public Meter meter(String name) {
        return this.meter(name, NO_TAGS);
    }

    public Meter meter(Metadata metadata) {
        return this.meter(metadata, NO_TAGS);
    }

    public Meter meter(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, Meter.class, tags);
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, Meter.class, tags);
    }

    public Timer timer(String name) {
        return this.timer(name, NO_TAGS);
    }

    public Timer timer(Metadata metadata) {
        return this.timer(metadata, NO_TAGS);
    }

    public Timer timer(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, Timer.class, tags);
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, Timer.class, tags);
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return this.concurrentGauge(name, NO_TAGS);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return this.concurrentGauge(metadata, NO_TAGS);
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, ConcurrentGauge.class, tags);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, ConcurrentGauge.class, tags);
    }

    public SimpleTimer simpleTimer(String name) {
        return this.simpleTimer(name, NO_TAGS);
    }

    public SimpleTimer simpleTimer(Metadata metadata) {
        return this.simpleTimer(metadata, NO_TAGS);
    }

    public SimpleTimer simpleTimer(String name, Tag ... tags) {
        return this.getOrRegisterMetric(name, SimpleTimer.class, tags);
    }

    public SimpleTimer simpleTimer(Metadata metadata, Tag ... tags) {
        return this.getOrRegisterMetric(metadata, SimpleTimer.class, tags);
    }

    public synchronized boolean remove(String name) {
        List<Map.Entry<MetricID, M>> doomedMetrics = this.getMetricsByName(name);
        if (doomedMetrics.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (Map.Entry<MetricID, M> doomedMetric : doomedMetrics) {
            ((HelidonMetric)doomedMetric.getValue()).markAsDeleted();
            result |= this.allMetrics.remove(doomedMetric.getKey()) != null;
        }
        this.allMetricIDsByName.remove(name);
        this.allMetadata.remove(name);
        return result;
    }

    public synchronized boolean remove(MetricID metricID) {
        HelidonMetric doomedMetric;
        List<MetricID> metricIDS = this.allMetricIDsByName.get(metricID.getName());
        if (metricIDS == null) {
            return false;
        }
        metricIDS.remove(metricID);
        if (metricIDS.isEmpty()) {
            this.allMetricIDsByName.remove(metricID.getName());
            this.allMetadata.remove(metricID.getName());
        }
        if ((doomedMetric = (HelidonMetric)this.allMetrics.remove(metricID)) != null) {
            doomedMetric.markAsDeleted();
        }
        return doomedMetric != null;
    }

    public synchronized void removeMatching(MetricFilter filter) {
        this.allMetrics.entrySet().stream().filter(entry -> filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())).forEach(entry -> this.remove((MetricID)entry.getKey()));
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.allMetricIDsByName.keySet());
    }

    public SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.allMetrics.keySet());
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.getSortedMetrics(filter, Gauge.class);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Counter.class);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.getSortedMetrics(filter, Histogram.class);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Meter.class);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.getSortedMetrics(filter, Timer.class);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.getSortedMetrics(filter, ConcurrentGauge.class);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers() {
        return this.getSimpleTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter filter) {
        return this.getSortedMetrics(filter, SimpleTimer.class);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.allMetadata);
    }

    public Map<MetricID, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.allMetrics);
    }

    public Optional<Metric> getMetric(String metricName) {
        return this.getOptionalMetricEntry(metricName).map(Map.Entry::getValue);
    }

    public String type() {
        return this.type.getName();
    }

    public boolean empty() {
        return this.allMetrics.isEmpty();
    }

    public String toString() {
        return this.type() + ": " + this.allMetrics.size() + " metrics";
    }

    public synchronized Optional<Map.Entry<? extends Metric, List<MetricID>>> getOptionalMetricWithIDsEntry(String metricName) {
        List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
        if (metricIDs == null || metricIDs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AbstractMap.SimpleEntry<HelidonMetric, List<MetricID>>((HelidonMetric)this.allMetrics.get(metricIDs.get(0)), metricIDs));
    }

    public M getMetric(MetricID metricID) {
        return (M)((HelidonMetric)this.allMetrics.get(metricID));
    }

    protected boolean isStrictExemplars() {
        return this.registrySettings.isStrictExemplars();
    }

    protected Stream<Map.Entry<MetricID, M>> stream() {
        return this.allMetrics.entrySet().stream().filter(entry -> this.registrySettings().isMetricEnabled(((MetricID)entry.getKey()).getName()));
    }

    protected abstract <T extends Metric> M toImpl(Metadata var1, T var2);

    protected abstract Map<MetricType, BiFunction<String, Metadata, M>> prepareMetricFactories();

    protected RegistrySettings registrySettings() {
        return this.registrySettings;
    }

    protected Optional<Map.Entry<MetricID, M>> getOptionalMetricEntry(String metricName) {
        return this.getOptionalMetricWithIDsEntry(metricName).map(entry -> {
            MetricID metricID = (MetricID)((List)entry.getValue()).get(0);
            return new AbstractMap.SimpleImmutableEntry<MetricID, HelidonMetric>(metricID, (HelidonMetric)this.allMetrics.get(metricID));
        });
    }

    private Optional<M> getOptionalMetric(String metricName, Tag ... tags) {
        return this.getOptionalMetric(new MetricID(metricName, tags));
    }

    private Optional<M> getOptionalMetric(MetricID metricID) {
        return Optional.ofNullable((HelidonMetric)this.allMetrics.get(metricID));
    }

    protected List<Map.Entry<MetricID, M>> getMetricsByName(String metricName) {
        List<MetricID> metricIDs = this.allMetricIDsByName.get(metricName);
        if (metricIDs == null) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<MetricID, M>> result = new ArrayList<Map.Entry<MetricID, M>>();
        for (MetricID metricID : metricIDs) {
            result.add(new AbstractMap.SimpleEntry<MetricID, HelidonMetric>(metricID, (HelidonMetric)this.allMetrics.get(metricID)));
        }
        return result;
    }

    protected MetricRegistry.Type registryType() {
        return this.type;
    }

    protected List<MetricID> metricIDsForName(String metricName) {
        return this.allMetricIDsByName.get(metricName);
    }

    static <T extends Metadata, U extends Metadata> boolean metadataMatches(T a, U b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getName().equals(b.getName()) && a.getTypeRaw().equals((Object)b.getTypeRaw()) && a.getDisplayName().equals(b.getDisplayName()) && Objects.equals(a.getDescription(), b.getDescription()) && Objects.equals(a.getUnit(), b.getUnit()) && a.isReusable() == b.isReusable();
    }

    private static boolean enforceConsistentMetadata(Metadata existingMetadata, Metadata newMetadata, Tag ... tags) {
        if (!AbstractRegistry.metadataMatches(existingMetadata, newMetadata)) {
            throw new IllegalArgumentException("New metric " + new MetricID(newMetadata.getName(), tags) + " with metadata " + newMetadata + " conflicts with a metric already registered with metadata " + existingMetadata);
        }
        return true;
    }

    private <T extends M> boolean enforceConsistentMetadata(T existingMetric, Metadata newMetadata, Tag ... tags) {
        return AbstractRegistry.enforceConsistentMetadata(existingMetric.metadata(), newMetadata, tags);
    }

    private static boolean enforceConsistentMetadataType(Metadata existingMetadata, MetricType newType, Tag ... tags) {
        if (!existingMetadata.getTypeRaw().equals((Object)newType)) {
            throw new IllegalArgumentException("Attempting to register a new metric " + new MetricID(existingMetadata.getName(), tags) + " of type " + newType.toString() + " found pre-existing metadata with conflicting type " + existingMetadata.getTypeRaw().toString());
        }
        return true;
    }

    private synchronized <U extends Metric> U getOrRegisterMetric(Metadata newMetadata, Class<U> clazz, Tag ... tags) throws IllegalArgumentException {
        String metricName = newMetadata.getName();
        return this.toType(this.getOptionalMetric(metricName, tags).filter(existingMetric -> this.enforceConsistentMetadata(existingMetric, newMetadata, tags)).orElseGet(() -> {
            this.warnOfMismatchedType(clazz, newMetadata);
            Metadata metadata = this.getOrRegisterMetadata(metricName, newMetadata, tags);
            return this.registerMetric(metricName, this.createEnabledAwareMetric(metricName, clazz, metadata), tags);
        }), clazz);
    }

    private synchronized <U extends Metric> U getOrRegisterMetric(String metricName, Class<U> clazz, Tag ... tags) {
        MetricType newType = MetricType.from(clazz);
        return this.toType(this.getOptionalMetric(metricName, tags).orElseGet(() -> {
            Metadata metadata = this.getOrRegisterMetadata(metricName, newType, () -> Metadata.builder().withName(metricName).withType(newType).build(), tags);
            return this.registerMetric(metricName, this.createEnabledAwareMetric(metricName, clazz, metadata), tags);
        }), clazz);
    }

    private synchronized <T extends Metric> T registerUniqueMetric(String metricName, T metric) throws IllegalArgumentException {
        this.enforceMetricUniqueness(metricName);
        MetricType metricType = MetricType.from(metric.getClass());
        Metadata metadata = this.getOrRegisterMetadata(metricName, metricType, () -> Metadata.builder().withName(metricName).withType(metricType).build(), NO_TAGS);
        this.registerMetric(metricName, this.toEnabledAwareImpl(metricName, metadata, metric), NO_TAGS);
        return metric;
    }

    private synchronized <T extends Metric> T registerUniqueMetric(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        String metricName = metadata.getName();
        this.enforceMetricUniqueness(metricName, tags);
        metadata = this.getOrRegisterMetadata(metricName, metadata, tags);
        this.registerMetric(metricName, this.toEnabledAwareImpl(metricName, metadata, metric), tags);
        return metric;
    }

    private <U extends Metric> M createEnabledAwareMetric(String metricName, Class<U> clazz, Metadata metadata) {
        MetricType metricType = MetricType.from(clazz);
        return (M)(this.registrySettings().isMetricEnabled(metricName) ? (HelidonMetric)this.metricFactories.get(MetricType.from(clazz)).apply(this.type.getName(), metadata) : (HelidonMetric)this.metricClass.cast(Proxy.newProxyInstance(this.metricClass.getClassLoader(), new Class[]{clazz, this.metricClass}, (InvocationHandler)new DisabledMetricInvocationHandler(metricType, metricName, metadata))));
    }

    private <T extends Metric> M toEnabledAwareImpl(String metricName, Metadata metadata, T metric) {
        return (M)(this.registrySettings().isMetricEnabled(metricName) ? this.toImpl(metadata, metric) : (HelidonMetric)this.metricClass.cast(Proxy.newProxyInstance(this.metricClass.getClassLoader(), new Class[]{AbstractRegistry.toMetricClass(metric), this.metricClass}, (InvocationHandler)new DisabledMetricInvocationHandler(MetricType.from(metric.getClass()), metricName, metadata))));
    }

    private <U extends Metric> void warnOfMismatchedType(Class<U> clazz, Metadata metadata) {
        if (!metadata.getTypeRaw().equals((Object)MetricType.from(clazz))) {
            LOGGER.log(Level.WARNING, String.format("MetricType '%s' from metadata conflicts with metric type '%s' being created", metadata.getTypeRaw(), MetricType.from(clazz)), new IllegalArgumentException());
        }
    }

    private boolean enforceMetricUniqueness(String metricName) {
        return this.enforceMetricUniqueness(new MetricID(metricName));
    }

    private boolean enforceMetricUniqueness(String metricName, Tag ... tags) {
        return this.enforceMetricUniqueness(new MetricID(metricName, tags));
    }

    private boolean enforceMetricUniqueness(MetricID metricID) {
        if (this.allMetrics.containsKey(metricID)) {
            throw new IllegalArgumentException("Attempt to reregister the existing metric " + metricID);
        }
        return true;
    }

    private <T extends M, U extends Metric> U toType(T m1, Class<U> clazz) {
        MetricType type2;
        MetricType type1 = this.toType((Metric)m1);
        if (type1 == (type2 = MetricType.from(clazz))) {
            return (U)((Metric)clazz.cast(m1));
        }
        throw new IllegalArgumentException("Metric types " + type1.toString() + " and " + type2.toString() + " do not match");
    }

    private synchronized Metadata getOrRegisterMetadata(String metricName, Metadata newMetadata, Tag ... tags) {
        return this.getOptionalMetadata(metricName).filter(existingMetadata -> AbstractRegistry.enforceConsistentMetadata(existingMetadata, newMetadata, tags)).orElseGet(() -> this.registerMetadata(newMetadata));
    }

    private synchronized Metadata getOrRegisterMetadata(String metricName, MetricType newMetricType, Supplier<Metadata> metadataFactory, Tag ... tags) {
        return this.getOptionalMetadata(metricName).filter(existingMetadata -> AbstractRegistry.enforceConsistentMetadataType(existingMetadata, newMetricType, tags)).orElseGet(() -> this.registerMetadata((Metadata)metadataFactory.get()));
    }

    private Optional<Metadata> getOptionalMetadata(String name) {
        return Optional.ofNullable(this.allMetadata.get(name));
    }

    private Metadata registerMetadata(Metadata metadata) {
        this.allMetadata.put(metadata.getName(), metadata);
        return metadata;
    }

    private synchronized <T extends M> T registerMetric(String metricName, T metric, Tag ... tags) {
        MetricID metricID = new MetricID(metricName, tags);
        this.allMetrics.put(metricID, metric);
        List metricIDsWithSameName = this.allMetricIDsByName.computeIfAbsent(metricName, k -> new ArrayList());
        metricIDsWithSameName.add(metricID);
        return metric;
    }

    protected static MetricType deriveType(MetricType candidateType, Metric metric) {
        if (candidateType != MetricType.INVALID) {
            return candidateType;
        }
        return Stream.of(Counter.class, Gauge.class, Histogram.class, Meter.class, Timer.class, ConcurrentGauge.class).filter(clazz -> clazz.isInstance(metric)).map(MetricType::from).findFirst().orElse(MetricType.INVALID);
    }

    private MetricType toType(Metric metric) {
        Class<Metric> clazz = AbstractRegistry.toMetricClass(metric);
        return MetricType.from(clazz == null ? metric.getClass() : clazz);
    }

    private static <T extends Metric> Class<? extends Metric> toMetricClass(T metric) {
        Class clazz = metric.getClass();
        do {
            Optional<Class> optionalClass;
            if (!(optionalClass = Arrays.stream(clazz.getInterfaces()).filter(Metric.class::isAssignableFrom).findFirst()).isPresent()) continue;
            clazz = optionalClass.get();
            break;
        } while ((clazz = clazz.getSuperclass()) != null);
        return clazz;
    }

    protected Map<MetricType, BiFunction<String, Metadata, M>> metricFactories() {
        return this.metricFactories;
    }

    private <V> SortedMap<MetricID, V> getSortedMetrics(MetricFilter filter, Class<V> metricClass) {
        Map<MetricID, Object> collected = this.allMetrics.entrySet().stream().filter(it -> metricClass.isAssignableFrom(((HelidonMetric)it.getValue()).getClass())).filter(it -> filter.matches((MetricID)it.getKey(), (Metric)it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> metricClass.cast(it.getValue())));
        return new TreeMap<MetricID, Object>(collected);
    }

    protected abstract Map<Class<? extends M>, MetricType> prepareMetricToTypeMap();

    private static class DisabledMetricInvocationHandler
    implements InvocationHandler {
        private final NoOpMetric delegate;

        DisabledMetricInvocationHandler(MetricType metricType, String metricName, Metadata metadata) {
            this.delegate = NoOpMetricRegistry.noOpMetricFactories().get(metricType).apply(metricName, metadata);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.delegate, args);
        }
    }
}

