/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.AbstractMetric;
import io.helidon.metrics.api.NoOpMetric;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

class NoOpMetricImpl
extends AbstractMetric
implements NoOpMetric {
    protected NoOpMetricImpl(String registryType, Metadata metadata) {
        super(registryType, metadata);
    }

    static Snapshot snapshot() {
        return new NoOpSnapshot();
    }

    private static Timer.Context timerContext() {
        return new NoOpTimerImpl.Context(){};
    }

    private static SimpleTimer.Context simpleTimerContext() {
        return new NoOpSimpleTimerImpl.Context();
    }

    static class NoOpSimpleTimerImpl
    extends NoOpMetricImpl
    implements SimpleTimer {
        static NoOpSimpleTimerImpl create(String registryType, Metadata metadata) {
            return new NoOpSimpleTimerImpl(registryType, metadata);
        }

        private NoOpSimpleTimerImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void update(Duration duration) {
        }

        public <T> T time(Callable<T> event) throws Exception {
            return event.call();
        }

        public void time(Runnable event) {
            event.run();
        }

        public SimpleTimer.Context time() {
            return NoOpMetricImpl.simpleTimerContext();
        }

        public Duration getElapsedTime() {
            return null;
        }

        public long getCount() {
            return 0L;
        }

        static class Context
        implements SimpleTimer.Context {
            Context() {
            }

            public long stop() {
                return 0L;
            }

            public void close() {
            }
        }
    }

    static class NoOpTimerImpl
    extends NoOpMetricImpl
    implements Timer {
        static NoOpTimerImpl create(String registryType, Metadata metadata) {
            return new NoOpTimerImpl(registryType, metadata);
        }

        private NoOpTimerImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void update(long duration, TimeUnit unit) {
        }

        public <T> T time(Callable<T> event) throws Exception {
            return event.call();
        }

        public void time(Runnable event) {
            event.run();
        }

        public Timer.Context time() {
            return NoOpMetricImpl.timerContext();
        }

        public long getCount() {
            return 0L;
        }

        public double getFifteenMinuteRate() {
            return 0.0;
        }

        public double getFiveMinuteRate() {
            return 0.0;
        }

        public double getMeanRate() {
            return 0.0;
        }

        public double getOneMinuteRate() {
            return 0.0;
        }

        public Snapshot getSnapshot() {
            return NoOpTimerImpl.snapshot();
        }

        static class Context
        implements Timer.Context {
            Context() {
            }

            public long stop() {
                return 0L;
            }

            public void close() {
            }
        }
    }

    static class NoOpMeterImpl
    extends NoOpMetricImpl
    implements Meter {
        static NoOpMeterImpl create(String registryType, Metadata metadata) {
            return new NoOpMeterImpl(registryType, metadata);
        }

        private NoOpMeterImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void mark() {
        }

        public void mark(long n) {
        }

        public long getCount() {
            return 0L;
        }

        public double getFifteenMinuteRate() {
            return 0.0;
        }

        public double getFiveMinuteRate() {
            return 0.0;
        }

        public double getMeanRate() {
            return 0.0;
        }

        public double getOneMinuteRate() {
            return 0.0;
        }
    }

    static class NoOpSnapshot
    extends Snapshot {
        NoOpSnapshot() {
        }

        public double getValue(double quantile) {
            return 0.0;
        }

        public long[] getValues() {
            return new long[0];
        }

        public int size() {
            return 0;
        }

        public long getMax() {
            return 0L;
        }

        public double getMean() {
            return 0.0;
        }

        public long getMin() {
            return 0L;
        }

        public double getStdDev() {
            return 0.0;
        }

        public void dump(OutputStream output) {
        }
    }

    static class NoOpHistogramImpl
    extends NoOpMetricImpl
    implements Histogram {
        static NoOpHistogramImpl create(String registryType, Metadata metadata) {
            return new NoOpHistogramImpl(registryType, metadata);
        }

        private NoOpHistogramImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void update(int value) {
        }

        public void update(long value) {
        }

        public long getCount() {
            return 0L;
        }

        public Snapshot getSnapshot() {
            return NoOpHistogramImpl.snapshot();
        }
    }

    static class NoOpGaugeImpl<T>
    extends NoOpMetricImpl
    implements Gauge<T> {
        private final Supplier<T> value = () -> metric.getValue();

        static <S> NoOpGaugeImpl<S> create(String registryType, Metadata metadata, Gauge<S> metric) {
            return new NoOpGaugeImpl<S>(registryType, metadata, metric);
        }

        static <S> NoOpGaugeImpl<S> create(String registryType, Metadata metadata) {
            return new NoOpGaugeImpl(registryType, metadata, () -> null);
        }

        private NoOpGaugeImpl(String registryType, Metadata metadata, Gauge<T> metric) {
            super(registryType, metadata);
        }

        public T getValue() {
            return this.value.get();
        }
    }

    static class NoOpConcurrentGaugeImpl
    extends NoOpMetricImpl
    implements ConcurrentGauge {
        static NoOpConcurrentGaugeImpl create(String registryType, Metadata metadata) {
            return new NoOpConcurrentGaugeImpl(registryType, metadata);
        }

        private NoOpConcurrentGaugeImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public long getCount() {
            return 0L;
        }

        public long getMax() {
            return 0L;
        }

        public long getMin() {
            return 0L;
        }

        public void inc() {
        }

        public void dec() {
        }
    }

    static class NoOpCounterImpl
    extends NoOpMetricImpl
    implements Counter {
        static NoOpCounterImpl create(String registryType, Metadata metadata) {
            return new NoOpCounterImpl(registryType, metadata);
        }

        static NoOpCounterImpl create(String registryType, Metadata metadata, Counter counter) {
            return new NoOpCounterImpl(registryType, metadata);
        }

        private NoOpCounterImpl(String registryType, Metadata metadata) {
            super(registryType, metadata);
        }

        public void inc() {
        }

        public void inc(long n) {
        }

        public long getCount() {
            return 0L;
        }
    }
}

