/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsSettingsImpl;

public interface KeyPerformanceIndicatorMetricsSettings {
    public static KeyPerformanceIndicatorMetricsSettings create(Config kpiConfig) {
        return KeyPerformanceIndicatorMetricsSettings.builder().config(kpiConfig).build();
    }

    public static Builder builder() {
        return new KeyPerformanceIndicatorMetricsSettingsImpl.Builder();
    }

    public static Builder builder(KeyPerformanceIndicatorMetricsSettings kpiMetricsSettings) {
        return KeyPerformanceIndicatorMetricsSettings.builder().extended(kpiMetricsSettings.isExtended()).longRunningRequestThresholdMs(kpiMetricsSettings.longRunningRequestThresholdMs());
    }

    public boolean isExtended();

    public long longRunningRequestThresholdMs();

    public static interface Builder
    extends io.helidon.common.Builder<KeyPerformanceIndicatorMetricsSettings> {
        public static final String KEY_PERFORMANCE_INDICATORS_CONFIG_KEY = "key-performance-indicators";
        public static final String KEY_PERFORMANCE_INDICATORS_EXTENDED_CONFIG_KEY = "extended";
        public static final boolean KEY_PERFORMANCE_INDICATORS_EXTENDED_DEFAULT = false;
        public static final String LONG_RUNNING_REQUESTS_THRESHOLD_CONFIG_KEY = "threshold-ms";
        public static final String LONG_RUNNING_REQUESTS_CONFIG_KEY = "long-running-requests";
        public static final long LONG_RUNNING_REQUESTS_THRESHOLD_MS_DEFAULT = 10000L;
        public static final String CONFIG_KEY_PREFIX = "metrics.key-performance-indicators";
        public static final String QUALIFIED_LONG_RUNNING_REQUESTS_THRESHOLD_CONFIG_KEY = "long-running-requests.extended";

        public Builder extended(boolean var1);

        public Builder longRunningRequestThresholdMs(long var1);

        public Builder config(Config var1);

        public KeyPerformanceIndicatorMetricsSettings build();

        public boolean isExtended();

        public long longRunningRequestThresholdMs();
    }
}

