/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.LazyValue;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.metrics.api.ComponentMetricsSettings;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.api.NoOpRegistryFactory;
import io.helidon.metrics.api.RegistryFactory;
import io.helidon.metrics.api.spi.RegistryFactoryProvider;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

class RegistryFactoryManager {
    private static final Logger LOGGER = Logger.getLogger(RegistryFactoryManager.class.getName());
    private static final LazyValue<RegistryFactoryProvider> LAZY_FACTORY_PROVIDER = LazyValue.create(RegistryFactoryManager::loadRegistryFactoryProvider);
    private static final RegistryFactoryProvider NO_OP_FACTORY_PROVIDER = metricsSettings -> NoOpRegistryFactory.create();
    private static final RegistryFactory INSTANCE = RegistryFactoryManager.create();
    private static final RegistryFactory NO_OP_INSTANCE = NoOpRegistryFactory.create();

    private static RegistryFactoryProvider loadRegistryFactoryProvider() {
        RegistryFactoryProvider provider = (RegistryFactoryProvider)HelidonServiceLoader.builder(ServiceLoader.load(RegistryFactoryProvider.class)).addService((Object)NO_OP_FACTORY_PROVIDER, Integer.MAX_VALUE).build().asList().get(0);
        LOGGER.log(Level.FINE, "Metrics registry factory provider: {0}", provider.getClass().getName());
        return provider;
    }

    private RegistryFactoryManager() {
    }

    static RegistryFactory create() {
        return RegistryFactoryManager.create(MetricsSettings.builder().build());
    }

    static RegistryFactory create(MetricsSettings metricsSettings) {
        return metricsSettings.isEnabled() ? ((RegistryFactoryProvider)LAZY_FACTORY_PROVIDER.get()).create(metricsSettings) : NO_OP_FACTORY_PROVIDER.create(metricsSettings);
    }

    @Deprecated
    static RegistryFactory create(Config config) {
        return RegistryFactoryManager.create(MetricsSettings.create(config));
    }

    static RegistryFactory getInstance() {
        return INSTANCE;
    }

    static synchronized RegistryFactory getInstance(MetricsSettings metricsSettings) {
        INSTANCE.update(metricsSettings);
        return INSTANCE;
    }

    static synchronized RegistryFactory getInstance(ComponentMetricsSettings componentMetricsSettings) {
        return componentMetricsSettings.isEnabled() ? INSTANCE : NO_OP_INSTANCE;
    }

    @Deprecated
    static RegistryFactory getInstance(Config config) {
        return RegistryFactoryManager.getInstance(MetricsSettings.create(config));
    }
}

